/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceXMLLoadersFactory.java,v 1.9 2010/05/11 16:30:04 jwest Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * Intel - contention analysis support is added 
 * 
 * $Id: TraceXMLLoadersFactory.java,v 1.9 2010/05/11 16:30:04 jwest Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentLoadersFactory;

/**
 * 
 * @author slavescu
 */
public class TraceXMLLoadersFactory implements XMLFragmentLoadersFactory {
    //~ Methods ------------------------------------------------------------------------------------

    protected static final String methodEntry = "methodEntry";
	protected static final String methodExit = "methodExit";
    protected static final String methodCall = "methodCall";
	protected static final String methodReturn = "methodReturn";

	protected static final String methodReceive = "methodReceive";
	protected static final String methodReply = "methodReply";

	protected static final String objAlloc = "objAlloc";
	protected static final String objFree = "objFree";
	protected static final String methodDef = "methodDef";
	protected static final String classDef = "classDef";
	protected static final String threadStart = "threadStart";
	protected static final String threadEnd = "threadEnd";
	protected static final String gcStart = "gcStart";
	protected static final String gcFinish = "gcFinish";
	protected static final String gcRoot = "gcRoot";
	protected static final String traceStart = "traceStart";
	protected static final String traceEnd = "traceEnd";
	protected static final String runtimeShutdown = "runtimeShutdown";
	protected static final String runtimeInitDone = "runtimeInitDone";
	protected static final String heapDumpDef = "heapDumpDef";
	protected static final String objReference = "objReference";
	protected static final String monWait = "monWait";
	protected static final String monWaited = "monWaited";
	protected static final String monContendedEnter = "monContendedEnter";
	protected static final String monContendedEntered = "monContendedEntered";
	protected static final String monStillOwned = "monStillOwned";

	protected static final String methodCount = "methodCount";
	protected static final String methodInvocations = "methodInvocations";
	
	protected static final String agMethodEntry = "agMethodEntry";
	protected static final String agMethodExit = "agMethodExit";

	protected static final String monNotifyCalled = "monNotifyCalled";
	protected static final String threadInterruptCalled = "threadInterruptCalled";
	protected static final String threadStartCalled = "threadStartCalled";
	
	protected static final String threadSleepStart = "threadSleepStart";
	protected static final String threadSleepEnd = "threadSleepEnd";
	

	// ignored fragments
	protected static final String parameterDef = "parameterDef";
	    
	public String getLoaderClassName(String elementName) {
		switch (LoadersUtils.getHashCode(elementName)) {
			case TraceConstants.methodEntry_int:
				return XMLmethodEntryLoader.class.getName();
			case TraceConstants.methodExit_int :
				return XMLmethodExitLoader.class.getName();
			case TraceConstants.methodCall_int:
			case TraceConstants.methodReceive_int:
				return XMLmethodCallLoader.class.getName();
			case TraceConstants.methodReturn_int :
			case TraceConstants.methodReply_int:
				return XMLmethodReturnLoader.class.getName();
			case TraceConstants.objAlloc_int:
				return XMLobjAllocLoader.class.getName();
			case TraceConstants.objFree_int :
				return XMLobjFreeLoader.class.getName();
			case TraceConstants.methodDef_int :
				return XMLmethodDefLoader.class.getName();
			case TraceConstants.classDef_int :
				return XMLclassDefLoader.class.getName();
			case TraceConstants.threadStart_int :
				return XMLthreadStartLoader.class.getName();
			case TraceConstants.threadEnd_int :
				return XMLthreadEndLoader.class.getName();
			case TraceConstants.gcStart_int :
				return XMLgcStartLoader.class.getName();
			case TraceConstants.gcFinish_int :
				return XMLgcFinishLoader.class.getName();
			case TraceConstants.gcRoot_int :
				return XMLgcRootLoader.class.getName();
			case TraceConstants.traceStart_int :
				return XMLtraceStartLoader.class.getName();
			case TraceConstants.traceEnd_int :
				return XMLtraceEndLoader.class.getName();
			case TraceConstants.runtimeShutdown_int :
				return XMLruntimeShutdownLoader.class.getName();
			case TraceConstants.runtimeInitDone_int :
				return XMLruntimeInitDoneLoader.class.getName();
			case TraceConstants.heapDumpDef_int :
				return XMLheapDumpDefLoader.class.getName();
			case TraceConstants.objReference_int :
				return XMLobjReferenceLoader.class.getName();
			case TraceConstants.monWait_int :
				return XMLmonWaitLoader.class.getName();
			case TraceConstants.monWaited_int :
				return XMLmonWaitedLoader.class.getName();
			case TraceConstants.monContendedEnter_int :
				return XMLmonContendedEnterLoader.class.getName();
			case TraceConstants.monContendedEntered_int :
				return XMLmonContendedEnteredLoader.class.getName();
			case TraceConstants.monStillOwned_int :
				return XMLmonStillOwnedLoader.class.getName();
			case TraceConstants.threadSleepStart_int:
				return XMLthreadSleepStartLoader.class.getName();
			case TraceConstants.threadSleepEnd_int:
				return XMLthreadSleepEndLoader.class.getName();
			case TraceConstants.methodCount_int :
			case TraceConstants.methodInvocations_int :
				return XMLmethodInvocationsLoader.class.getName();
			case TraceConstants.agMethodEntry_int :
				return XMLagMethodEntryLoader.class.getName();
			case TraceConstants.monNotifyCalled_int :
				return XMLmonNotifyCalledLoader.class.getName();
			case TraceConstants.threadInterruptCalled_int :
				return XMLthreadInterruptCalledLoader.class.getName();
			case TraceConstants.threadStartCalled_int :
				return XMLthreadStartCalledLoader.class.getName();
			case TraceConstants.agMethodExit_int :
				return XMLagMethodExitLoader.class.getName();
			// ignored events
			case TraceConstants.parameterDef_int :
				return IgnoredXMLFragmentLoader.class.getName();
			default :
				return null;
		}
    }

    public Set getSupportedElements() {
        Set set = new HashSet();

        set.add(traceStart);
        set.add(traceEnd);
        set.add(threadStart);
        set.add(threadEnd);
        set.add(classDef);
        set.add(objAlloc);
		set.add(objFree);
		set.add(heapDumpDef);
		set.add(objReference);
        set.add(gcStart);
        set.add(gcFinish);
        set.add(gcRoot);
        set.add(methodDef);
        set.add(methodEntry);
        set.add(methodExit);
        set.add(methodCall);
        set.add(methodReturn);
        set.add(runtimeShutdown);
        set.add(runtimeInitDone);
        set.add(monWait);
        set.add(monWaited);
        set.add(monContendedEnter);
        set.add(monContendedEntered);
        set.add(monStillOwned);

        set.add(methodReceive);
        set.add(methodReply);
        
        set.add(methodCount);
        set.add(methodInvocations);

        set.add(agMethodEntry);
        set.add(agMethodExit);

        set.add(monNotifyCalled);
        set.add(threadInterruptCalled);
        set.add(threadStartCalled);
        
    	set.add(threadSleepStart);
    	set.add(threadSleepEnd);
        
        //ignored events
        set.add(parameterDef);
        
        return set;
    }

}
