/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id$
 **********************************************************************/

package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.util.ModelDebugger;

/**
 * @author slavescu
 *
 */
public class XMLagMethodExitLoader extends TraceMethodBaseLoader {

	public void addYourselfInContext() {
		if (ModelDebugger.INSTANCE.debug) {
			System.out.println("pop");
		}
		if (context.isFilterOn()) {
			if (context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey(methodIdRef))) {
				return;
			}
		}		

        theProcess = getProcess();
        theThread = getThreadByIdRef(theProcess);

        // See StackLookup notes for why this could just be
        // a Map containing TRCAggregatedMethodInvocations rather
        // than a Stack. The "pop" operation just means replacing
        // the value for this thread with a reference to
        // the invokedBy object.
        
		cs = (CallStackPerThread) LookupServiceExtensions.getInstance().locate(context, CallStackPerThread.class, threadIdRef);
        if (cs == null) {
    		if (ModelDebugger.INSTANCE.debug) {
            	//Not supposed to happen
            	System.err.println("no Stack registered on method return");
    		}        	
        	return;
        }
        
        if (cs.empty()) {
    		if (ModelDebugger.INSTANCE.debug) {
            	System.err.println("Stack underflow in method return");
    		}        	
        	return;
        }
        cs.pop();
	}
}
