/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLgcFinishLoader.java,v 1.4 2007/02/21 21:03:50 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCGCEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * @author slavescu
 *
 */
public class XMLgcFinishLoader extends TraceXMLFragmentLoader {
    protected static final String TOTAL_OBJECT_SPACE = "totalObjectSpace";
    protected static final String USED_OBJECT_SPACE = "usedObjectSpace";
    protected static final String USED_OBJECTS = "usedObjects";
	protected long totalObjectSpace;
	protected long usedObjectSpace;
	protected long usedObjects;
	
	public void addAttribute(String name, String value) {
        if (!loadToModel) {
            return;
        }

        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.TOTAL_OBJECT_SPACE_int:
        	totalObjectSpace = Long.parseLong(value);

            break;
        case TraceConstants.USED_OBJECT_SPACE_int:
        	usedObjectSpace = Long.parseLong(value);

            break;
        case TraceConstants.USED_OBJECTS_int:
        	usedObjects = Long.parseLong(value);

            break;
        }
		super.addAttribute(name, value);
	}
	public void addYourselfInContext() {
       if (!loadToModel) {
            return;
        }
		if (context.isFilterOn()) {
			if (context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(), LoadersUtils.getLookUpKey(threadIdRef))) {
				return;
			}
		}
		
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		
		TRCGCEvent event = TraceFactory.eINSTANCE.createTRCGCEvent();
		event.setType(getEventType());
		event.setOwnerThread(theThread);
		if(totalObjectSpace>0)
			event.setTotalObjectSpace(totalObjectSpace);
		if(usedObjectSpace>0)
			event.setUsedObjectSpace(usedObjectSpace);
		if(usedObjects>0)
			event.setUsedObjects(usedObjects);
		
		event.setTime(createDeltaTime());
		
		theProcess.getGcEvents().add(event);
		
	}
	protected String getEventType() {
		return "finish";
	}
	public void initialize(HierarchyContext context, String name) {
        loadToModel = context.isLoadToModel();

        if (!loadToModel) {
            return;
        }

        super.initialize(context, name);
        totalObjectSpace = -1;
        usedObjectSpace = -1;
        usedObjects = -1;
    }
}
