/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLmethodDefLoader.java,v 1.13 2006/12/04 16:58:46 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmethodDefLoader.java,v 1.13 2006/12/04 16:58:46 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodProperties;
import org.eclipse.hyades.models.trace.TRCSignatureNotation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;
import org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl;

/**
 * @author slavescu
 *
 */
public class XMLmethodDefLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

//	protected static final String NAME = "name";
    protected static final String START_LINE_NUMBER = "startLineNumber";
    protected static final String END_LINE_NUMBER = "endLineNumber";
    protected static final String SIGNATURE = "signature";
    protected static final String SIG_NOTATION = "sigNotation";
    protected static final String METHOD_ID = "methodId";

    //~ Instance fields ----------------------------------------------------------------------------

    protected String access;
    protected String name;
    protected String signature;
    protected TRCSignatureNotation sigNotation;
    protected int methodId;
    protected int endLineNumber;
    protected int startLineNumber;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.METHOD_ID_int:
            methodId = Integer.parseInt(value);

            break;

        case TraceConstants.NAME_int:
        	if(currentAnnotation!=null)
        		currentAnnotation.setName(value);
        	else
        		this.name = value;

            break;

        case TraceConstants.SIG_NOTATION_int:
            sigNotation = TRCSignatureNotation.get(value);

            break;

        case TraceConstants.SIGNATURE_int:
            signature = value;

            break;

        case TraceConstants.START_LINE_NUMBER_int:
            startLineNumber = Integer.parseInt(value);

            break;
        case TraceConstants.END_LINE_NUMBER_int:
            endLineNumber = Integer.parseInt(value);

            break;

        default:
            super.addAttribute(name, value);

            break;
        }
    }

    public void addYourselfInContext() {
        if (name == null || name.length()==0) {
            name = UNKNOWN;
        }
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCClass_Name(),LoadersUtils.getLookUpKey(classIdRef)))
			{
				context.getFilterEngine().addExcludedId(TracePackage.eINSTANCE.getTRCMethod_Name(),LoadersUtils.getLookUpKey(methodId));
				return;
			}
	    	theProcess = getProcess();
			getTRCClass();
			String realName;
			if(name.equals("-init-") && theClass!=null)
			{
				realName = theClass.getName(); 
			}
			else
				realName = name;
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCMethod_Name(),LoadersUtils.getLookUpKey(methodId),realName))
			{
				return;
			}
		}

		if(theProcess==null)
			theProcess = getProcess();

        if (sigNotation == null) {
            sigNotation = TRCSignatureNotation.JNI_LITERAL;
        }

		Class clazz = TraceUtils.isBooleanOptionEnabled(context,Constants.LLDATA_ENABLED) ? TRCMethodWithLLDataImpl.class : TRCMethodImpl.class;
        theMethod = (TRCMethod) LookupServiceExtensions.getInstance().locate(context, clazz, methodId);

        //        theClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, LoadersUtils.getLookUpKey(classIdRef));
        dispatchProcessMode(ProcessSteps.ALL);

        if (theMethod == null) {
            theMethod = createTRCMethod(theClass);
            theMethod.setId(methodId);
            theMethod.setDefiningClass(theClass);
        }
		if(sourceName!=null)
			TraceUtils.setSourceInfo(context, theProcess, theMethod, sourceName,language);

		addLanguageIfRequired(theProcess.getLanguages());
        addAnnotationsIfRequired(theMethod);
       	

        if (TraceUtils.isConstructor(name)) {
            theMethod.setModifier(theMethod.getModifier() | TRCMethodProperties.JAVA_CONSTRUCTOR);
        }

        theMethod.setName(TraceUtils.getMethodName(theMethod, name));
        theMethod.setSignature(TraceUtils.convertMethodSignature(theMethod, signature));
        theMethod.setNotation(sigNotation);
        theMethod.setLineNo(startLineNumber);
        theMethod.setLineCount(endLineNumber-startLineNumber);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        name = null;
        access = null;
        signature = null;
        startLineNumber = 0;
        endLineNumber = 0;
        sigNotation = null;
        methodId = 0;
		sourceName = null;
		language=null;
		annotations.clear();
    }

    protected void getTRCClass() {
        if (theClass == null) {
            if (theProcess.getThreads().size() > 0) {
                theClass = getClassByIdRef((TRCThread) theProcess.getThreads().get(theProcess.getThreads().size() - 1), TRCTraceObjectImpl.class,0);
            } else {
                theClass = getClassByIdRef(getThreadByIdRef(theProcess), TRCTraceObjectImpl.class,0);
            }
        }
    }

    /**
     *
     */
    protected void processEF(int step) {
        super.processEF(0);
        getTRCClass();
    }

    /**
     *
     */
    protected void processES(int step) {
        super.processES(step);
        getTRCClass();
    }

    /**
     *
     */
    protected void processHF(int step) {
        super.processHF(0);
        getTRCClass();
    }

    /**
     *
     */
    protected void processHS(int step) {
        super.processHS(0);
        getTRCClass();
    }
}
