/**********************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: XMLmonNotifyCalledLoader.java,v 1.4 2008/04/14 10:57:30 aalexeev Exp $
 *
 * Contributors:
 * Intel - Initial contribution
 **********************************************************************/ 

package org.eclipse.hyades.loaders.trace;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCThreadExecEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;

public class XMLmonNotifyCalledLoader extends TraceXMLThreadEventsLoader {

	protected static final String IS_NOTIFY_ALL = "isNotifyAll";
	
	protected boolean isNotifyAll = false;
	
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.isNotifyAll_int :
				isNotifyAll = value.equals("1");
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}		
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		
		TRCThreadExecEvent event = null;
		if (isNotifyAll) {
			TRCThreadNotifyAllEvent notifyAllEvent = 
				TraceFactory.eINSTANCE.createTRCThreadNotifyAllEvent();
			event = notifyAllEvent;
			
			getThreadEventsContext().getMonitor2NotifyAllMap().put(theObject, notifyAllEvent);
		}
		else {
			TRCThreadNotifyEvent notifyEvent = 
				TraceFactory.eINSTANCE.createTRCThreadNotifyEvent();
			event = notifyEvent;

			List notifyEventList = (List)getThreadEventsContext().getMonitor2NotifyMap().get(theObject);
			if (notifyEventList == null) {
				notifyEventList = new ArrayList(); //TODO: choose better list
			}
			notifyEventList.add(notifyEvent);
			getThreadEventsContext().getMonitor2NotifyMap().put(theObject, notifyEventList);
		}
		
		event.setTime(createDeltaTime());
		addAnnotationsIfRequired(event);
	    addInteractionEvent(theThread, event);
	}	
}
