/**********************************************************************
 * Copyright (c) 2003, 2006, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLthreadEndLoader.java,v 1.9 2008/03/12 15:46:45 aalexeev Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * Intel - loader is extended for contention analysis support   
 *
 * $Id: XMLthreadEndLoader.java,v 1.9 2008/03/12 15:46:45 aalexeev Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 *  
 */
public class XMLthreadEndLoader extends TraceXMLThreadEventsLoader {
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		TRCThread thread = (TRCThread) LookupServiceExtensions.getInstance().locate(context, TRCThreadImpl.class, threadIdRef);
		if (thread != null) {
			thread.setStopTime(createDeltaTime());

			//TODO: if some JVM produce event in incorrect order then
			//add search for already resumed thread on monitor 
			TRCThreadDeadAndNotifyJoinedEvent eventDeadAndNotify = TraceFactory.eINSTANCE.createTRCThreadDeadAndNotifyJoinedEvent();
			eventDeadAndNotify.setThread(thread);
			eventDeadAndNotify.setTime(thread.getStopTime());
			thread.getThreadEvents().add(eventDeadAndNotify);
			getThreadEventsContext().getThread2ThreadDeadNotifyEventMap().put(thread, eventDeadAndNotify);

			TRCThreadDeadEvent eventDead = TraceFactory.eINSTANCE.createTRCThreadDeadEvent();
			eventDead.setTime(thread.getStopTime());
			addAnnotationsIfRequired(thread);
			thread.getThreadEvents().add(eventDead);
		}
	}
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		annotations.clear();
	}
}