/**********************************************************************
 * Copyright (c) 2008, 2010 Intel Corporation and others.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: XMLthreadInterruptCalledLoader.java,v 1.5 2010/05/11 16:30:05 jwest Exp $
 *
 * Contributors:
 * Intel - Initial contribution
 **********************************************************************/ 

package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;

public class XMLthreadInterruptCalledLoader extends TraceXMLThreadEventsLoader {

	private TRCThreadSleepingEvent createThreadSleepingEvent(TRCThread interruptedThread) {
		ThreadSleepStartEntry lastEntry = null;
		
		
		List/*<Object>*/ sleepData = getThreadEventsContext().getThreadSleepData(interruptedThread.getId());

		if(sleepData == null) return null;

		// Get the most recent ThreadSleepStartEntry from the list
		for(Iterator it = sleepData.iterator(); it.hasNext();) {
			Object o = it.next();
			if(o instanceof ThreadSleepStartEntry) {
				lastEntry = (ThreadSleepStartEntry)o;
			}
		}
		
		if(lastEntry == null) {
			return null;
		}
		
		sleepData.remove(lastEntry);

		TRCThreadSleepingEvent sleepingEvent = TraceFactory.eINSTANCE.createTRCThreadSleepingEvent();
		
		long sleepTimeInMsecs = (long)((time - lastEntry.getThreadSleepStartTime()) * 1000);
		
		sleepingEvent.setSleepingTime( (int) sleepTimeInMsecs);
		sleepingEvent.setTime(lastEntry.getThreadSleepStartTime()- getZeroTime());

		sleepingEvent.setThread(interruptedThread);

		addAnnotationsIfRequired(sleepingEvent);
		
		return sleepingEvent;
	}

	
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		TRCThread interruptedThread = (TRCThread)getThreadEventsContext()
			.getObject2ThreadMap().get(theObject);

		if(interruptedThread != null) {
			
			// Check if the thread was already sleeping, if so, create the thread event
			TRCThreadSleepingEvent sleepEvent = createThreadSleepingEvent(interruptedThread);
			if(sleepEvent != null) {
				interruptedThread.getThreadEvents().add(sleepEvent);
				
				// Create a running event for after 
				TRCThreadRunningEvent runningEvent = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
				runningEvent.setTime(createDeltaTime()); //time);
				addAnnotationsIfRequired(runningEvent);
				interruptedThread.getThreadEvents().add(runningEvent);

			}
		}
		
		TRCThreadInterruptThreadEvent interruptEvent = 
			TraceFactory.eINSTANCE.createTRCThreadInterruptThreadEvent();
		interruptEvent.setInterruptedThread(interruptedThread);

		interruptEvent.setTime(createDeltaTime());
		addAnnotationsIfRequired(interruptEvent);
        addInteractionEvent(theThread, interruptEvent);
		
		getThreadEventsContext().getThread2InterruptionMap().put(interruptedThread, interruptEvent);
	}
}
