/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCAggregatedObjectReferenceImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Aggregated Object Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl#getOwnerSize <em>Owner Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl#getTargetSize <em>Target Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl#getCount <em>Count</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCAggregatedObjectReferenceImpl extends TRCObjectReferenceImpl implements TRCAggregatedObjectReference {
	/**
	 * The default value of the '{@link #getOwnerSize() <em>Owner Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerSize()
	 * @generated
	 * @ordered
	 */
	protected static final int OWNER_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getOwnerSize() <em>Owner Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerSize()
	 * @generated
	 * @ordered
	 */
	protected int ownerSize = OWNER_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTargetSize() <em>Target Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetSize()
	 * @generated
	 * @ordered
	 */
	protected static final int TARGET_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTargetSize() <em>Target Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetSize()
	 * @generated
	 * @ordered
	 */
	protected int targetSize = TARGET_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected static final int COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected int count = COUNT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCAggregatedObjectReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_AGGREGATED_OBJECT_REFERENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getOwnerSize() {
		return ownerSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerSize(int newOwnerSize) {
		int oldOwnerSize = ownerSize;
		ownerSize = newOwnerSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE, oldOwnerSize, ownerSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTargetSize() {
		return targetSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTargetSize(int newTargetSize) {
		int oldTargetSize = targetSize;
		targetSize = newTargetSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE, oldTargetSize, targetSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCount() {
		return count;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCount(int newCount) {
		int oldCount = count;
		count = newCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT, oldCount, count));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE:
				return getOwnerSize();
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE:
				return getTargetSize();
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT:
				return getCount();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE:
				setOwnerSize((Integer)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE:
				setTargetSize((Integer)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT:
				setCount((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE:
				setOwnerSize(OWNER_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE:
				setTargetSize(TARGET_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE:
				return ownerSize != OWNER_SIZE_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE:
				return targetSize != TARGET_SIZE_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT:
				return count != COUNT_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (ownerSize: ");
		result.append(ownerSize);
		result.append(", targetSize: ");
		result.append(targetSize);
		result.append(", count: ");
		result.append(count);
		result.append(')');
		return result.toString();
	}

} //TRCAggregatedObjectReferenceImpl
