/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCCallerCalleeInvocationInfoImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Caller Callee Invocation Info</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl#getCallTime <em>Call Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl#getReturnTime <em>Return Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl#getCallOverhead <em>Call Overhead</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCCallerCalleeInvocationInfoImpl extends TRCFullMethodInvocationImpl implements TRCCallerCalleeInvocationInfo {
	/**
	 * The default value of the '{@link #getCallTime() <em>Call Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CALL_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCallTime() <em>Call Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallTime()
	 * @generated
	 * @ordered
	 */
	protected double callTime = CALL_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getReturnTime() <em>Return Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReturnTime()
	 * @generated
	 * @ordered
	 */
	protected static final double RETURN_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getReturnTime() <em>Return Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReturnTime()
	 * @generated
	 * @ordered
	 */
	protected double returnTime = RETURN_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCallOverhead() <em>Call Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallOverhead()
	 * @generated
	 * @ordered
	 */
	protected static final double CALL_OVERHEAD_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCallOverhead() <em>Call Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallOverhead()
	 * @generated
	 * @ordered
	 */
	protected double callOverhead = CALL_OVERHEAD_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCCallerCalleeInvocationInfoImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_CALLER_CALLEE_INVOCATION_INFO;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCallTime() {
		return callTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCallTime(double newCallTime) {
		double oldCallTime = callTime;
		callTime = newCallTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME, oldCallTime, callTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getReturnTime() {
		return returnTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReturnTime(double newReturnTime) {
		double oldReturnTime = returnTime;
		returnTime = newReturnTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME, oldReturnTime, returnTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCallOverhead() {
		return callOverhead;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCallOverhead(double newCallOverhead) {
		double oldCallOverhead = callOverhead;
		callOverhead = newCallOverhead;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD, oldCallOverhead, callOverhead));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME:
				return getCallTime();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME:
				return getReturnTime();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD:
				return getCallOverhead();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME:
				setCallTime((Double)newValue);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME:
				setReturnTime((Double)newValue);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD:
				setCallOverhead((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME:
				setCallTime(CALL_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME:
				setReturnTime(RETURN_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD:
				setCallOverhead(CALL_OVERHEAD_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME:
				return callTime != CALL_TIME_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME:
				return returnTime != RETURN_TIME_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD:
				return callOverhead != CALL_OVERHEAD_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (callTime: ");
		result.append(callTime);
		result.append(", returnTime: ");
		result.append(returnTime);
		result.append(", callOverhead: ");
		result.append(callOverhead);
		result.append(')');
		return result.toString();
	}

} //TRCCallerCalleeInvocationInfoImpl
