/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCFullMethodInvocationImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Full Method Invocation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getStackDepth <em>Stack Depth</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getEntryTime <em>Entry Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getExitTime <em>Exit Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getTicket <em>Ticket</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getOverhead <em>Overhead</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getCallerLineNo <em>Caller Line No</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl#getCpuTime <em>Cpu Time</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCFullMethodInvocationImpl extends TRCMethodInvocationImpl implements TRCFullMethodInvocation {
	/**
	 * The default value of the '{@link #getStackDepth() <em>Stack Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStackDepth()
	 * @generated
	 * @ordered
	 */
	protected static final short STACK_DEPTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getStackDepth() <em>Stack Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStackDepth()
	 * @generated
	 * @ordered
	 */
	protected short stackDepth = STACK_DEPTH_EDEFAULT;

	/**
	 * The default value of the '{@link #getEntryTime() <em>Entry Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryTime()
	 * @generated
	 * @ordered
	 */
	protected static final double ENTRY_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getEntryTime() <em>Entry Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryTime()
	 * @generated
	 * @ordered
	 */
	protected double entryTime = ENTRY_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getExitTime() <em>Exit Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExitTime()
	 * @generated
	 * @ordered
	 */
	protected static final double EXIT_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getExitTime() <em>Exit Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExitTime()
	 * @generated
	 * @ordered
	 */
	protected double exitTime = EXIT_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTicket() <em>Ticket</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTicket()
	 * @generated
	 * @ordered
	 */
	protected static final long TICKET_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTicket() <em>Ticket</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTicket()
	 * @generated
	 * @ordered
	 */
	protected long ticket = TICKET_EDEFAULT;

	/**
	 * The default value of the '{@link #getOverhead() <em>Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverhead()
	 * @generated
	 * @ordered
	 */
	protected static final double OVERHEAD_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getOverhead() <em>Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverhead()
	 * @generated
	 * @ordered
	 */
	protected double overhead = OVERHEAD_EDEFAULT;

	/**
	 * The default value of the '{@link #getCallerLineNo() <em>Caller Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallerLineNo()
	 * @generated
	 * @ordered
	 */
	protected static final int CALLER_LINE_NO_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCallerLineNo() <em>Caller Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallerLineNo()
	 * @generated
	 * @ordered
	 */
	protected int callerLineNo = CALLER_LINE_NO_EDEFAULT;

	/**
	 * The default value of the '{@link #getCpuTime() <em>Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCpuTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CPU_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCpuTime() <em>Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCpuTime()
	 * @generated
	 * @ordered
	 */
	protected double cpuTime = CPU_TIME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCFullMethodInvocationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_FULL_METHOD_INVOCATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getStackDepth() {
		return stackDepth;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStackDepth(short newStackDepth) {
		short oldStackDepth = stackDepth;
		stackDepth = newStackDepth;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH, oldStackDepth, stackDepth));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getEntryTime() {
		return entryTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEntryTime(double newEntryTime) {
		double oldEntryTime = entryTime;
		entryTime = newEntryTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME, oldEntryTime, entryTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getExitTime() {
		return exitTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExitTime(double newExitTime) {
		double oldExitTime = exitTime;
		exitTime = newExitTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME, oldExitTime, exitTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTicket() {
		return ticket;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTicket(long newTicket) {
		long oldTicket = ticket;
		ticket = newTicket;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET, oldTicket, ticket));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getOverhead() {
		return overhead;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOverhead(double newOverhead) {
		double oldOverhead = overhead;
		overhead = newOverhead;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD, oldOverhead, overhead));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCallerLineNo() {
		return callerLineNo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCallerLineNo(int newCallerLineNo) {
		int oldCallerLineNo = callerLineNo;
		callerLineNo = newCallerLineNo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO, oldCallerLineNo, callerLineNo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCpuTime() {
		return cpuTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCpuTime(double newCpuTime) {
		double oldCpuTime = cpuTime;
		cpuTime = newCpuTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME, oldCpuTime, cpuTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH:
				return getStackDepth();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME:
				return getEntryTime();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME:
				return getExitTime();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET:
				return getTicket();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD:
				return getOverhead();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO:
				return getCallerLineNo();
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME:
				return getCpuTime();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH:
				setStackDepth((Short)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME:
				setEntryTime((Double)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME:
				setExitTime((Double)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET:
				setTicket((Long)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD:
				setOverhead((Double)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO:
				setCallerLineNo((Integer)newValue);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME:
				setCpuTime((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH:
				setStackDepth(STACK_DEPTH_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME:
				setEntryTime(ENTRY_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME:
				setExitTime(EXIT_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET:
				setTicket(TICKET_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD:
				setOverhead(OVERHEAD_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO:
				setCallerLineNo(CALLER_LINE_NO_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME:
				setCpuTime(CPU_TIME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_FULL_METHOD_INVOCATION__STACK_DEPTH:
				return stackDepth != STACK_DEPTH_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__ENTRY_TIME:
				return entryTime != ENTRY_TIME_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__EXIT_TIME:
				return exitTime != EXIT_TIME_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__TICKET:
				return ticket != TICKET_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__OVERHEAD:
				return overhead != OVERHEAD_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CALLER_LINE_NO:
				return callerLineNo != CALLER_LINE_NO_EDEFAULT;
			case TracePackage.TRC_FULL_METHOD_INVOCATION__CPU_TIME:
				return cpuTime != CPU_TIME_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (stackDepth: ");
		result.append(stackDepth);
		result.append(", entryTime: ");
		result.append(entryTime);
		result.append(", exitTime: ");
		result.append(exitTime);
		result.append(", ticket: ");
		result.append(ticket);
		result.append(", overhead: ");
		result.append(overhead);
		result.append(", callerLineNo: ");
		result.append(callerLineNo);
		result.append(", cpuTime: ");
		result.append(cpuTime);
		result.append(')');
		return result.toString();
	}

} //TRCFullMethodInvocationImpl
