/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCHeapDumpImpl.java,v 1.11 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Heap Dump</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl#getEntryTime <em>Entry Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl#getExitTime <em>Exit Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl#getReferences <em>References</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl#getGcRoots <em>Gc Roots</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCHeapDumpImpl extends EObjectImpl implements TRCHeapDump {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final short ID_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected short id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getEntryTime() <em>Entry Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryTime()
	 * @generated
	 * @ordered
	 */
	protected static final double ENTRY_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getEntryTime() <em>Entry Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryTime()
	 * @generated
	 * @ordered
	 */
	protected double entryTime = ENTRY_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getExitTime() <em>Exit Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExitTime()
	 * @generated
	 * @ordered
	 */
	protected static final double EXIT_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getExitTime() <em>Exit Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExitTime()
	 * @generated
	 * @ordered
	 */
	protected double exitTime = EXIT_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getReferences() <em>References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCObjectReference> references;

	/**
	 * The cached value of the '{@link #getGcRoots() <em>Gc Roots</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGcRoots()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCHeapRoot> gcRoots;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCHeapDumpImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_HEAP_DUMP;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(short newId) {
		short oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_DUMP__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getEntryTime() {
		return entryTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEntryTime(double newEntryTime) {
		double oldEntryTime = entryTime;
		entryTime = newEntryTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_DUMP__ENTRY_TIME, oldEntryTime, entryTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getExitTime() {
		return exitTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExitTime(double newExitTime) {
		double oldExitTime = exitTime;
		exitTime = newExitTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_DUMP__EXIT_TIME, oldExitTime, exitTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_DUMP__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCObjectReference> getReferences() {
		if (references == null) {
			references = new EObjectContainmentWithInverseEList<TRCObjectReference>(TRCObjectReference.class, this, TracePackage.TRC_HEAP_DUMP__REFERENCES, TracePackage.TRC_OBJECT_REFERENCE__HEAP_DUMP);
		}
		return references;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID() != TracePackage.TRC_HEAP_DUMP__PROCESS) return null;
		return (TRCProcess)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcess(TRCProcess newProcess, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_HEAP_DUMP__PROCESS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eInternalContainer() || (eContainerFeatureID() != TracePackage.TRC_HEAP_DUMP__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__HEAP_DUMPS, TRCProcess.class, msgs);
			msgs = basicSetProcess(newProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_HEAP_DUMP__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCHeapRoot> getGcRoots() {
		if (gcRoots == null) {
			gcRoots = new EObjectContainmentWithInverseEList<TRCHeapRoot>(TRCHeapRoot.class, this, TracePackage.TRC_HEAP_DUMP__GC_ROOTS, TracePackage.TRC_HEAP_ROOT__HEAP_DUMP);
		}
		return gcRoots;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_DUMP__REFERENCES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getReferences()).basicAdd(otherEnd, msgs);
			case TracePackage.TRC_HEAP_DUMP__PROCESS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetProcess((TRCProcess)otherEnd, msgs);
			case TracePackage.TRC_HEAP_DUMP__GC_ROOTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getGcRoots()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_DUMP__REFERENCES:
				return ((InternalEList<?>)getReferences()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_HEAP_DUMP__PROCESS:
				return basicSetProcess(null, msgs);
			case TracePackage.TRC_HEAP_DUMP__GC_ROOTS:
				return ((InternalEList<?>)getGcRoots()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case TracePackage.TRC_HEAP_DUMP__PROCESS:
				return eInternalContainer().eInverseRemove(this, TracePackage.TRC_PROCESS__HEAP_DUMPS, TRCProcess.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_DUMP__ID:
				return getId();
			case TracePackage.TRC_HEAP_DUMP__ENTRY_TIME:
				return getEntryTime();
			case TracePackage.TRC_HEAP_DUMP__EXIT_TIME:
				return getExitTime();
			case TracePackage.TRC_HEAP_DUMP__NAME:
				return getName();
			case TracePackage.TRC_HEAP_DUMP__REFERENCES:
				return getReferences();
			case TracePackage.TRC_HEAP_DUMP__PROCESS:
				return getProcess();
			case TracePackage.TRC_HEAP_DUMP__GC_ROOTS:
				return getGcRoots();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_DUMP__ID:
				setId((Short)newValue);
				return;
			case TracePackage.TRC_HEAP_DUMP__ENTRY_TIME:
				setEntryTime((Double)newValue);
				return;
			case TracePackage.TRC_HEAP_DUMP__EXIT_TIME:
				setExitTime((Double)newValue);
				return;
			case TracePackage.TRC_HEAP_DUMP__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_HEAP_DUMP__REFERENCES:
				getReferences().clear();
				getReferences().addAll((Collection<? extends TRCObjectReference>)newValue);
				return;
			case TracePackage.TRC_HEAP_DUMP__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_HEAP_DUMP__GC_ROOTS:
				getGcRoots().clear();
				getGcRoots().addAll((Collection<? extends TRCHeapRoot>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_DUMP__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_HEAP_DUMP__ENTRY_TIME:
				setEntryTime(ENTRY_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_HEAP_DUMP__EXIT_TIME:
				setExitTime(EXIT_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_HEAP_DUMP__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_HEAP_DUMP__REFERENCES:
				getReferences().clear();
				return;
			case TracePackage.TRC_HEAP_DUMP__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_HEAP_DUMP__GC_ROOTS:
				getGcRoots().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_HEAP_DUMP__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_HEAP_DUMP__ENTRY_TIME:
				return entryTime != ENTRY_TIME_EDEFAULT;
			case TracePackage.TRC_HEAP_DUMP__EXIT_TIME:
				return exitTime != EXIT_TIME_EDEFAULT;
			case TracePackage.TRC_HEAP_DUMP__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_HEAP_DUMP__REFERENCES:
				return references != null && !references.isEmpty();
			case TracePackage.TRC_HEAP_DUMP__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_HEAP_DUMP__GC_ROOTS:
				return gcRoots != null && !gcRoots.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", entryTime: ");
		result.append(entryTime);
		result.append(", exitTime: ");
		result.append(exitTime);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //TRCHeapDumpImpl
