/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCLineCoverageDataImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCLineCoverageData;
import org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.util.LLUnitData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Line Coverage Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl#getLineTable <em>Line Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl#getHitTable <em>Hit Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl#getCountTable <em>Count Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLineCoverageDataImpl#getSourceInfo <em>Source Info</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCLineCoverageDataImpl extends TRCLLDataImpl implements TRCLineCoverageData {
	/**
	 * The default value of the '{@link #getLineTable() <em>Line Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineTable()
	 * @generated
	 * @ordered
	 */
	protected static final int[] LINE_TABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLineTable() <em>Line Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineTable()
	 * @generated
	 * @ordered
	 */
	protected int[] lineTable = LINE_TABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getHitTable() <em>Hit Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHitTable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean[] HIT_TABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHitTable() <em>Hit Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHitTable()
	 * @generated
	 * @ordered
	 */
	protected boolean[] hitTable = HIT_TABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCountTable() <em>Count Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountTable()
	 * @generated
	 * @ordered
	 */
	protected static final int[] COUNT_TABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCountTable() <em>Count Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountTable()
	 * @generated
	 * @ordered
	 */
	protected int[] countTable = COUNT_TABLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSourceInfo() <em>Source Info</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceInfo()
	 * @generated
	 * @ordered
	 */
	protected TRCSourceInfoWithLLData sourceInfo;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCLineCoverageDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_LINE_COVERAGE_DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int[] getLineTable() {
		return lineTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineTable(int[] newLineTable) {
		int[] oldLineTable = lineTable;
		lineTable = newLineTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE, oldLineTable, lineTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * In the case hitTable has not been provided, countTable is used to fill it in and ensure the
	 * availability service to hit-only consumers. This behavior is NOT generated by EMF engine.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean[] getHitTable() {
		if (hitTable == null && countTable != null) {
			boolean ret[] = new boolean[countTable.length];
			for (int i = 0; i < countTable.length; i++) {
				ret[i] = countTable[i] > 0;
			}
			// hitTable cannot be used for this because it is serialized and the choice is made to let
			// the model size as low as possible.
			// The opposite choice would have offered a better read performance, because consecutive calls
			// to getHitTable() would have caused only one table allocation and filling action.
			return ret;
		}
		return hitTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHitTable(boolean[] newHitTable) {
		boolean[] oldHitTable = hitTable;
		hitTable = newHitTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE, oldHitTable, hitTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int[] getCountTable() {
		return countTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCountTable(int[] newCountTable) {
		int[] oldCountTable = countTable;
		countTable = newCountTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE, oldCountTable, countTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfoWithLLData getSourceInfo() {
		if (sourceInfo != null && sourceInfo.eIsProxy()) {
			InternalEObject oldSourceInfo = (InternalEObject)sourceInfo;
			sourceInfo = (TRCSourceInfoWithLLData)eResolveProxy(oldSourceInfo);
			if (sourceInfo != oldSourceInfo) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO, oldSourceInfo, sourceInfo));
			}
		}
		return sourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfoWithLLData basicGetSourceInfo() {
		return sourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceInfo(TRCSourceInfoWithLLData newSourceInfo) {
		TRCSourceInfoWithLLData oldSourceInfo = sourceInfo;
		sourceInfo = newSourceInfo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO, oldSourceInfo, sourceInfo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE:
				return getLineTable();
			case TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE:
				return getHitTable();
			case TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE:
				return getCountTable();
			case TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO:
				if (resolve) return getSourceInfo();
				return basicGetSourceInfo();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE:
				setLineTable((int[])newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE:
				setHitTable((boolean[])newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE:
				setCountTable((int[])newValue);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO:
				setSourceInfo((TRCSourceInfoWithLLData)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE:
				setLineTable(LINE_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE:
				setHitTable(HIT_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE:
				setCountTable(COUNT_TABLE_EDEFAULT);
				return;
			case TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO:
				setSourceInfo((TRCSourceInfoWithLLData)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_LINE_COVERAGE_DATA__LINE_TABLE:
				return LINE_TABLE_EDEFAULT == null ? lineTable != null : !LINE_TABLE_EDEFAULT.equals(lineTable);
			case TracePackage.TRC_LINE_COVERAGE_DATA__HIT_TABLE:
				return HIT_TABLE_EDEFAULT == null ? hitTable != null : !HIT_TABLE_EDEFAULT.equals(hitTable);
			case TracePackage.TRC_LINE_COVERAGE_DATA__COUNT_TABLE:
				return COUNT_TABLE_EDEFAULT == null ? countTable != null : !COUNT_TABLE_EDEFAULT.equals(countTable);
			case TracePackage.TRC_LINE_COVERAGE_DATA__SOURCE_INFO:
				return sourceInfo != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int getUnitCount() {
		return lineTable != null ? lineTable.length : 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public LLUnitData getUnitData(int unitNumber, LLUnitData instance) {
		if (unitNumber < 0 || unitNumber >= getUnitCount()) {
			return null;
		}
		LLUnitData ret = instance;
		if (ret == null) {
			ret = new LLUnitData();
		}
		ret.setStartLine(lineTable[unitNumber]);
		if (hitTable != null) {
			ret.setHit(hitTable[unitNumber]);
		} else if (countTable != null) {
			ret.setHit(countTable[unitNumber] > 0);
			ret.setCount(countTable[unitNumber]);
		}
		ret.setSourceInfo(sourceInfo);
		return ret;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean hasCountInfo() {
		return countTable != null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean hasAccumulatedTimeInfo() {
		return false;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (lineTable: ");
		result.append(lineTable);
		result.append(", hitTable: ");
		result.append(hitTable);
		result.append(", countTable: ");
		result.append(countTable);
		result.append(')');
		return result.toString();
	}

} //TRCLineCoverageDataImpl
