/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCLinePerformanceDataImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCLinePerformanceData;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.util.LLUnitData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Line Performance Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCLinePerformanceDataImpl#getAccumulatedTimeTable <em>Accumulated Time Table</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCLinePerformanceDataImpl extends TRCLineCoverageDataImpl implements TRCLinePerformanceData {
	/**
	 * The default value of the '{@link #getAccumulatedTimeTable() <em>Accumulated Time Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccumulatedTimeTable()
	 * @generated
	 * @ordered
	 */
	protected static final double[] ACCUMULATED_TIME_TABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAccumulatedTimeTable() <em>Accumulated Time Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccumulatedTimeTable()
	 * @generated
	 * @ordered
	 */
	protected double[] accumulatedTimeTable = ACCUMULATED_TIME_TABLE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCLinePerformanceDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_LINE_PERFORMANCE_DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double[] getAccumulatedTimeTable() {
		return accumulatedTimeTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccumulatedTimeTable(double[] newAccumulatedTimeTable) {
		double[] oldAccumulatedTimeTable = accumulatedTimeTable;
		accumulatedTimeTable = newAccumulatedTimeTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE, oldAccumulatedTimeTable, accumulatedTimeTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE:
				return getAccumulatedTimeTable();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE:
				setAccumulatedTimeTable((double[])newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE:
				setAccumulatedTimeTable(ACCUMULATED_TIME_TABLE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_LINE_PERFORMANCE_DATA__ACCUMULATED_TIME_TABLE:
				return ACCUMULATED_TIME_TABLE_EDEFAULT == null ? accumulatedTimeTable != null : !ACCUMULATED_TIME_TABLE_EDEFAULT.equals(accumulatedTimeTable);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public LLUnitData getUnitData(int unitNumber, LLUnitData instance) {
		LLUnitData ret = super.getUnitData(unitNumber, instance);
		if (ret == null) {
			return null;
		}
		ret.setAccumulatedTime(accumulatedTimeTable[unitNumber]);
		return ret;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean hasCountInfo() {
		return super.hasCountInfo();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean hasAccumulatedTimeInfo() {
		return accumulatedTimeTable != null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (accumulatedTimeTable: ");
		result.append(accumulatedTimeTable);
		result.append(')');
		return result.toString();
	}

} //TRCLinePerformanceDataImpl
