/**********************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectAllocationAnnotationImpl.java,v 1.7 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.hyades.models.hierarchy.impl.TRCAnnotationImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Object Allocation Annotation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationAnnotationImpl#getMethods <em>Methods</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationAnnotationImpl#getClasses <em>Classes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationAnnotationImpl#getLineNumbers <em>Line Numbers</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationAnnotationImpl#getCreateTimes <em>Create Times</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCObjectAllocationAnnotationImpl extends TRCAnnotationImpl implements TRCObjectAllocationAnnotation {
	/**
	 * The cached value of the '{@link #getMethods() <em>Methods</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethods()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCMethod> methods;

	/**
	 * The cached value of the '{@link #getClasses() <em>Classes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClasses()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCClass> classes;

	/**
	 * The cached value of the '{@link #getLineNumbers() <em>Line Numbers</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineNumbers()
	 * @generated
	 * @ordered
	 */
	protected EList<Integer> lineNumbers;

	/**
	 * The cached value of the '{@link #getCreateTimes() <em>Create Times</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreateTimes()
	 * @generated
	 * @ordered
	 */
	protected EList<Double> createTimes;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCObjectAllocationAnnotationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_OBJECT_ALLOCATION_ANNOTATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getMethods() {
		if (methods == null) {
			methods = new EObjectResolvingEList(TRCMethod.class, this, TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__METHODS){
				private static final long serialVersionUID = -3082372511664894133L;
				protected boolean isUnique() {
					return false;//TracePackage.eINSTANCE.getTRCObjectAllocationAnnotation_Methods().isUnique();
				}

			};
		}
		return methods;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getClasses() {
		if (classes == null) {
			classes = new EObjectResolvingEList(TRCClass.class, this, TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CLASSES) {
				private static final long serialVersionUID = -3082372511664894133L;

				protected boolean isUnique() {
					return false;//TracePackage.eINSTANCE.getTRCObjectAllocationAnnotation_Classes().isUnique();
				}
			};
		}
		return classes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Integer> getLineNumbers() {
		if (lineNumbers == null) {
			lineNumbers = new EDataTypeEList<Integer>(Integer.class, this, TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__LINE_NUMBERS);
		}
		return lineNumbers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Double> getCreateTimes() {
		if (createTimes == null) {
			createTimes = new EDataTypeEList<Double>(Double.class, this, TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CREATE_TIMES);
		}
		return createTimes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__METHODS:
				return getMethods();
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CLASSES:
				return getClasses();
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__LINE_NUMBERS:
				return getLineNumbers();
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CREATE_TIMES:
				return getCreateTimes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__METHODS:
				getMethods().clear();
				getMethods().addAll((Collection<? extends TRCMethod>)newValue);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CLASSES:
				getClasses().clear();
				getClasses().addAll((Collection<? extends TRCClass>)newValue);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__LINE_NUMBERS:
				getLineNumbers().clear();
				getLineNumbers().addAll((Collection<? extends Integer>)newValue);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CREATE_TIMES:
				getCreateTimes().clear();
				getCreateTimes().addAll((Collection<? extends Double>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__METHODS:
				getMethods().clear();
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CLASSES:
				getClasses().clear();
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__LINE_NUMBERS:
				getLineNumbers().clear();
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CREATE_TIMES:
				getCreateTimes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__METHODS:
				return methods != null && !methods.isEmpty();
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CLASSES:
				return classes != null && !classes.isEmpty();
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__LINE_NUMBERS:
				return lineNumbers != null && !lineNumbers.isEmpty();
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION__CREATE_TIMES:
				return createTimes != null && !createTimes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (lineNumbers: ");
		result.append(lineNumbers);
		result.append(", createTimes: ");
		result.append(createTimes);
		result.append(')');
		return result.toString();
	}

} //TRCObjectAllocationAnnotationImpl
