/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectValueImpl.java,v 1.12 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Object Value</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl#getStringValue <em>String Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl#getTRCInputOutputEntry <em>TRC Input Output Entry</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectValueImpl#getContainer <em>Container</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCObjectValueImpl extends EObjectImpl implements TRCObjectValue {
	/**
	 * The default value of the '{@link #getStringValue() <em>String Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStringValue()
	 * @generated
	 * @ordered
	 */
	protected static final String STRING_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStringValue() <em>String Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStringValue()
	 * @generated
	 * @ordered
	 */
	protected String stringValue = STRING_VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContainer() <em>Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContainer()
	 * @generated
	 * @ordered
	 */
	protected TRCInputOutputContainer container;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCObjectValueImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_OBJECT_VALUE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getStringValue() {
		return stringValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStringValue(String newStringValue) {
		String oldStringValue = stringValue;
		stringValue = newStringValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_VALUE__STRING_VALUE, oldStringValue, stringValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> getTRCInputOutputEntry() {
		if (eContainerFeatureID() != TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY) return null;
		return (Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>>)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTRCInputOutputEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> newTRCInputOutputEntry, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newTRCInputOutputEntry, TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTRCInputOutputEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> newTRCInputOutputEntry) {
		if (newTRCInputOutputEntry != eInternalContainer() || (eContainerFeatureID() != TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY && newTRCInputOutputEntry != null)) {
			if (EcoreUtil.isAncestor(this, (EObject)newTRCInputOutputEntry))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTRCInputOutputEntry != null)
				msgs = ((InternalEObject)newTRCInputOutputEntry).eInverseAdd(this, TracePackage.TRC_INPUT_OUTPUT_ENTRY__VALUE, Map.Entry.class, msgs);
			msgs = basicSetTRCInputOutputEntry(newTRCInputOutputEntry, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY, newTRCInputOutputEntry, newTRCInputOutputEntry));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCInputOutputContainer getContainer() {
		return container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetContainer(TRCInputOutputContainer newContainer, NotificationChain msgs) {
		TRCInputOutputContainer oldContainer = container;
		container = newContainer;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_VALUE__CONTAINER, oldContainer, newContainer);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContainer(TRCInputOutputContainer newContainer) {
		if (newContainer != container) {
			NotificationChain msgs = null;
			if (container != null)
				msgs = ((InternalEObject)container).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES, TRCInputOutputContainer.class, msgs);
			if (newContainer != null)
				msgs = ((InternalEObject)newContainer).eInverseAdd(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES, TRCInputOutputContainer.class, msgs);
			msgs = basicSetContainer(newContainer, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_VALUE__CONTAINER, newContainer, newContainer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetTRCInputOutputEntry((Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>>)otherEnd, msgs);
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				if (container != null)
					msgs = ((InternalEObject)container).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES, TRCInputOutputContainer.class, msgs);
				return basicSetContainer((TRCInputOutputContainer)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				return basicSetTRCInputOutputEntry(null, msgs);
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				return basicSetContainer(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				return eInternalContainer().eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_ENTRY__VALUE, Map.Entry.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_VALUE__STRING_VALUE:
				return getStringValue();
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				return getTRCInputOutputEntry();
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				return getContainer();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_VALUE__STRING_VALUE:
				setStringValue((String)newValue);
				return;
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				setTRCInputOutputEntry((Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>>)newValue);
				return;
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				setContainer((TRCInputOutputContainer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_VALUE__STRING_VALUE:
				setStringValue(STRING_VALUE_EDEFAULT);
				return;
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				setTRCInputOutputEntry((Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>>)null);
				return;
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				setContainer((TRCInputOutputContainer)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_OBJECT_VALUE__STRING_VALUE:
				return STRING_VALUE_EDEFAULT == null ? stringValue != null : !STRING_VALUE_EDEFAULT.equals(stringValue);
			case TracePackage.TRC_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				return getTRCInputOutputEntry() != null;
			case TracePackage.TRC_OBJECT_VALUE__CONTAINER:
				return container != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (stringValue: ");
		result.append(stringValue);
		result.append(')');
		return result.toString();
	}

} //TRCObjectValueImpl
