/**********************************************************************
 * Copyright (c) 2008, 2009 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Intel - Initial API and implementation
 *
 * $Id: TRCThreadHandoffLockEventImpl.java,v 1.3 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Handoff Lock Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadHandoffLockEventImpl#getLockedObject <em>Locked Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadHandoffLockEventImpl extends TRCThreadExecEventImpl implements TRCThreadHandoffLockEvent {
	/**
	 * The cached value of the '{@link #getLockedObject() <em>Locked Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLockedObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject lockedObject;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadHandoffLockEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_THREAD_HANDOFF_LOCK_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getLockedObject() {
		if (lockedObject != null && lockedObject.eIsProxy()) {
			InternalEObject oldLockedObject = (InternalEObject)lockedObject;
			lockedObject = (TRCObject)eResolveProxy(oldLockedObject);
			if (lockedObject != oldLockedObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD_HANDOFF_LOCK_EVENT__LOCKED_OBJECT, oldLockedObject, lockedObject));
			}
		}
		return lockedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetLockedObject() {
		return lockedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLockedObject(TRCObject newLockedObject) {
		TRCObject oldLockedObject = lockedObject;
		lockedObject = newLockedObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_HANDOFF_LOCK_EVENT__LOCKED_OBJECT, oldLockedObject, lockedObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_HANDOFF_LOCK_EVENT__LOCKED_OBJECT:
				if (resolve) return getLockedObject();
				return basicGetLockedObject();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_HANDOFF_LOCK_EVENT__LOCKED_OBJECT:
				setLockedObject((TRCObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_HANDOFF_LOCK_EVENT__LOCKED_OBJECT:
				setLockedObject((TRCObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_HANDOFF_LOCK_EVENT__LOCKED_OBJECT:
				return lockedObject != null;
		}
		return super.eIsSet(featureID);
	}

} //TRCThreadHandoffLockEventImpl