/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCThreadImpl.java,v 1.12 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getGroupName <em>Group Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getMaxStackDepth <em>Max Stack Depth</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getTotalCpuTime <em>Total Cpu Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getInitialInvocations <em>Initial Invocations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getThreadObject <em>Thread Object</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getThreadEvents <em>Thread Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadImpl#getAnnotations <em>Annotations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadImpl extends EObjectImpl implements TRCThread {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final int ID_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected int id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getGroupName() <em>Group Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGroupName()
	 * @generated
	 * @ordered
	 */
	protected static final String GROUP_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getGroupName() <em>Group Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGroupName()
	 * @generated
	 * @ordered
	 */
	protected String groupName = GROUP_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected static final double START_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected double startTime = START_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected static final double STOP_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected double stopTime = STOP_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getMaxStackDepth() <em>Max Stack Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxStackDepth()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_STACK_DEPTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaxStackDepth() <em>Max Stack Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxStackDepth()
	 * @generated
	 * @ordered
	 */
	protected int maxStackDepth = MAX_STACK_DEPTH_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected static final double TOTAL_CPU_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected double totalCpuTime = TOTAL_CPU_TIME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInitialInvocations() <em>Initial Invocations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitialInvocations()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCMethodInvocation> initialInvocations;

	/**
	 * The cached value of the '{@link #getThreadObject() <em>Thread Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThreadObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject threadObject;

	/**
	 * The cached value of the '{@link #getThreadEvents() <em>Thread Events</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThreadEvents()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCThreadEvent> threadEvents;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCAnnotation> annotations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_THREAD;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(int newId) {
		int oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getGroupName() {
		return groupName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGroupName(String newGroupName) {
		String oldGroupName = groupName;
		groupName = newGroupName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__GROUP_NAME, oldGroupName, groupName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStartTime() {
		return startTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartTime(double newStartTime) {
		double oldStartTime = startTime;
		startTime = newStartTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__START_TIME, oldStartTime, startTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStopTime() {
		return stopTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStopTime(double newStopTime) {
		double oldStopTime = stopTime;
		stopTime = newStopTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__STOP_TIME, oldStopTime, stopTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMaxStackDepth() {
		return maxStackDepth;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaxStackDepth(int newMaxStackDepth) {
		int oldMaxStackDepth = maxStackDepth;
		maxStackDepth = newMaxStackDepth;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__MAX_STACK_DEPTH, oldMaxStackDepth, maxStackDepth));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTotalCpuTime() {
		return totalCpuTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalCpuTime(double newTotalCpuTime) {
		double oldTotalCpuTime = totalCpuTime;
		totalCpuTime = newTotalCpuTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__TOTAL_CPU_TIME, oldTotalCpuTime, totalCpuTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID() != TracePackage.TRC_THREAD__PROCESS) return null;
		return (TRCProcess)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcess(TRCProcess newProcess, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_THREAD__PROCESS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eInternalContainer() || (eContainerFeatureID() != TracePackage.TRC_THREAD__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__THREADS, TRCProcess.class, msgs);
			msgs = basicSetProcess(newProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getThreadObject() {
		if (threadObject != null && threadObject.eIsProxy()) {
			InternalEObject oldThreadObject = (InternalEObject)threadObject;
			threadObject = (TRCObject)eResolveProxy(oldThreadObject);
			if (threadObject != oldThreadObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD__THREAD_OBJECT, oldThreadObject, threadObject));
			}
		}
		return threadObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetThreadObject() {
		return threadObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setThreadObject(TRCObject newThreadObject) {
		TRCObject oldThreadObject = threadObject;
		threadObject = newThreadObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD__THREAD_OBJECT, oldThreadObject, threadObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCThreadEvent> getThreadEvents() {
		if (threadEvents == null) {
			threadEvents = new EObjectContainmentWithInverseEList<TRCThreadEvent>(TRCThreadEvent.class, this, TracePackage.TRC_THREAD__THREAD_EVENTS, TracePackage.TRC_THREAD_EVENT__THREAD);
		}
		return threadEvents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCAnnotation> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<TRCAnnotation>(TRCAnnotation.class, this, TracePackage.TRC_THREAD__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_THREAD__PROCESS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetProcess((TRCProcess)otherEnd, msgs);
			case TracePackage.TRC_THREAD__THREAD_EVENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getThreadEvents()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TracePackage.TRC_THREAD__PROCESS:
				return basicSetProcess(null, msgs);
			case TracePackage.TRC_THREAD__THREAD_EVENTS:
				return ((InternalEList<?>)getThreadEvents()).basicRemove(otherEnd, msgs);
			case TracePackage.TRC_THREAD__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case TracePackage.TRC_THREAD__PROCESS:
				return eInternalContainer().eInverseRemove(this, TracePackage.TRC_PROCESS__THREADS, TRCProcess.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_THREAD__ID:
				return getId();
			case TracePackage.TRC_THREAD__NAME:
				return getName();
			case TracePackage.TRC_THREAD__GROUP_NAME:
				return getGroupName();
			case TracePackage.TRC_THREAD__START_TIME:
				return getStartTime();
			case TracePackage.TRC_THREAD__STOP_TIME:
				return getStopTime();
			case TracePackage.TRC_THREAD__MAX_STACK_DEPTH:
				return getMaxStackDepth();
			case TracePackage.TRC_THREAD__TOTAL_CPU_TIME:
				return getTotalCpuTime();
			case TracePackage.TRC_THREAD__PROCESS:
				return getProcess();
			case TracePackage.TRC_THREAD__INITIAL_INVOCATIONS:
				return getInitialInvocations();
			case TracePackage.TRC_THREAD__THREAD_OBJECT:
				if (resolve) return getThreadObject();
				return basicGetThreadObject();
			case TracePackage.TRC_THREAD__THREAD_EVENTS:
				return getThreadEvents();
			case TracePackage.TRC_THREAD__ANNOTATIONS:
				return getAnnotations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_THREAD__ID:
				setId((Integer)newValue);
				return;
			case TracePackage.TRC_THREAD__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_THREAD__GROUP_NAME:
				setGroupName((String)newValue);
				return;
			case TracePackage.TRC_THREAD__START_TIME:
				setStartTime((Double)newValue);
				return;
			case TracePackage.TRC_THREAD__STOP_TIME:
				setStopTime((Double)newValue);
				return;
			case TracePackage.TRC_THREAD__MAX_STACK_DEPTH:
				setMaxStackDepth((Integer)newValue);
				return;
			case TracePackage.TRC_THREAD__TOTAL_CPU_TIME:
				setTotalCpuTime((Double)newValue);
				return;
			case TracePackage.TRC_THREAD__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_THREAD__INITIAL_INVOCATIONS:
				getInitialInvocations().clear();
				getInitialInvocations().addAll((Collection<? extends TRCMethodInvocation>)newValue);
				return;
			case TracePackage.TRC_THREAD__THREAD_OBJECT:
				setThreadObject((TRCObject)newValue);
				return;
			case TracePackage.TRC_THREAD__THREAD_EVENTS:
				getThreadEvents().clear();
				getThreadEvents().addAll((Collection<? extends TRCThreadEvent>)newValue);
				return;
			case TracePackage.TRC_THREAD__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends TRCAnnotation>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD__GROUP_NAME:
				setGroupName(GROUP_NAME_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD__STOP_TIME:
				setStopTime(STOP_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD__MAX_STACK_DEPTH:
				setMaxStackDepth(MAX_STACK_DEPTH_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD__TOTAL_CPU_TIME:
				setTotalCpuTime(TOTAL_CPU_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_THREAD__INITIAL_INVOCATIONS:
				getInitialInvocations().clear();
				return;
			case TracePackage.TRC_THREAD__THREAD_OBJECT:
				setThreadObject((TRCObject)null);
				return;
			case TracePackage.TRC_THREAD__THREAD_EVENTS:
				getThreadEvents().clear();
				return;
			case TracePackage.TRC_THREAD__ANNOTATIONS:
				getAnnotations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_THREAD__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_THREAD__GROUP_NAME:
				return GROUP_NAME_EDEFAULT == null ? groupName != null : !GROUP_NAME_EDEFAULT.equals(groupName);
			case TracePackage.TRC_THREAD__START_TIME:
				return startTime != START_TIME_EDEFAULT;
			case TracePackage.TRC_THREAD__STOP_TIME:
				return stopTime != STOP_TIME_EDEFAULT;
			case TracePackage.TRC_THREAD__MAX_STACK_DEPTH:
				return maxStackDepth != MAX_STACK_DEPTH_EDEFAULT;
			case TracePackage.TRC_THREAD__TOTAL_CPU_TIME:
				return totalCpuTime != TOTAL_CPU_TIME_EDEFAULT;
			case TracePackage.TRC_THREAD__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_THREAD__INITIAL_INVOCATIONS:
				return initialInvocations != null && !initialInvocations.isEmpty();
			case TracePackage.TRC_THREAD__THREAD_OBJECT:
				return threadObject != null;
			case TracePackage.TRC_THREAD__THREAD_EVENTS:
				return threadEvents != null && !threadEvents.isEmpty();
			case TracePackage.TRC_THREAD__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getInitialInvocations() {
		if (initialInvocations == null) {
       			initialInvocations = new EObjectResolvingEList(TRCMethodInvocation.class, this, TracePackage.TRC_THREAD__INITIAL_INVOCATIONS){
				// The designed default behavior in EMF is to treat entries in a list as unique and the code provides the required checking.
       			// This means the setting of the meta data has no effect in some cases and the cost if checking is carried. There is an EMF
       		    // bugzilla to change this behavior but that would break some users so it is left open.
       			// This fix honors the metadata setting and avoids the heavy cost of uniqueness checking.
       			private static final long serialVersionUID = 6280704097512113674L;
				private final boolean uniqueness = getEStructuralFeature().isUnique();
				protected boolean isUnique() {
					return uniqueness;
				}
			};
		}
		return initialInvocations;
	} 
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	  
	public EList getInitialInvocations() {
		if (initialInvocations == null) {
			initialInvocations = new EObjectResolvingEList(TRCMethodInvocation.class, this, TracePackage.TRC_THREAD__INITIAL_INVOCATIONS){
				protected boolean isUnique() {
					return false;
				}
			};
		}
		return initialInvocations;
	}	
	*/
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", name: ");
		result.append(name);
		result.append(", groupName: ");
		result.append(groupName);
		result.append(", startTime: ");
		result.append(startTime);
		result.append(", stopTime: ");
		result.append(stopTime);
		result.append(", maxStackDepth: ");
		result.append(maxStackDepth);
		result.append(", totalCpuTime: ");
		result.append(totalCpuTime);
		result.append(')');
		return result.toString();
	}

} //TRCThreadImpl
