/**********************************************************************
 * Copyright (c) 2008, 2009 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Intel - Initial API and implementation
 *
 * $Id: TRCThreadStartThreadEventImpl.java,v 1.3 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Start Thread Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadStartThreadEventImpl#getStartedThread <em>Started Thread</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadStartThreadEventImpl extends TRCThreadExecEventImpl implements TRCThreadStartThreadEvent {
	/**
	 * The cached value of the '{@link #getStartedThread() <em>Started Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartedThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread startedThread;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadStartThreadEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_THREAD_START_THREAD_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getStartedThread() {
		if (startedThread != null && startedThread.eIsProxy()) {
			InternalEObject oldStartedThread = (InternalEObject)startedThread;
			startedThread = (TRCThread)eResolveProxy(oldStartedThread);
			if (startedThread != oldStartedThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD_START_THREAD_EVENT__STARTED_THREAD, oldStartedThread, startedThread));
			}
		}
		return startedThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetStartedThread() {
		return startedThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartedThread(TRCThread newStartedThread) {
		TRCThread oldStartedThread = startedThread;
		startedThread = newStartedThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_START_THREAD_EVENT__STARTED_THREAD, oldStartedThread, startedThread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_START_THREAD_EVENT__STARTED_THREAD:
				if (resolve) return getStartedThread();
				return basicGetStartedThread();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_START_THREAD_EVENT__STARTED_THREAD:
				setStartedThread((TRCThread)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_START_THREAD_EVENT__STARTED_THREAD:
				setStartedThread((TRCThread)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_START_THREAD_EVENT__STARTED_THREAD:
				return startedThread != null;
		}
		return super.eIsSet(featureID);
	}

} //TRCThreadStartThreadEventImpl