/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCThreadWaitingForLockEventImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Waiting For Lock Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForLockEventImpl#getLockedObject <em>Locked Object</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForLockEventImpl#getLockingThread <em>Locking Thread</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadWaitingForLockEventImpl extends TRCThreadEventImpl implements TRCThreadWaitingForLockEvent {
	/**
	 * The cached value of the '{@link #getLockedObject() <em>Locked Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLockedObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject lockedObject;

	/**
	 * The cached value of the '{@link #getLockingThread() <em>Locking Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLockingThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread lockingThread;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadWaitingForLockEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_THREAD_WAITING_FOR_LOCK_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getLockedObject() {
		if (lockedObject != null && lockedObject.eIsProxy()) {
			InternalEObject oldLockedObject = (InternalEObject)lockedObject;
			lockedObject = (TRCObject)eResolveProxy(oldLockedObject);
			if (lockedObject != oldLockedObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT, oldLockedObject, lockedObject));
			}
		}
		return lockedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetLockedObject() {
		return lockedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLockedObject(TRCObject newLockedObject) {
		TRCObject oldLockedObject = lockedObject;
		lockedObject = newLockedObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT, oldLockedObject, lockedObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getLockingThread() {
		if (lockingThread != null && lockingThread.eIsProxy()) {
			InternalEObject oldLockingThread = (InternalEObject)lockingThread;
			lockingThread = (TRCThread)eResolveProxy(oldLockingThread);
			if (lockingThread != oldLockingThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD, oldLockingThread, lockingThread));
			}
		}
		return lockingThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetLockingThread() {
		return lockingThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLockingThread(TRCThread newLockingThread) {
		TRCThread oldLockingThread = lockingThread;
		lockingThread = newLockingThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD, oldLockingThread, lockingThread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT:
				if (resolve) return getLockedObject();
				return basicGetLockedObject();
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD:
				if (resolve) return getLockingThread();
				return basicGetLockingThread();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT:
				setLockedObject((TRCObject)newValue);
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD:
				setLockingThread((TRCThread)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT:
				setLockedObject((TRCObject)null);
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD:
				setLockingThread((TRCThread)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKED_OBJECT:
				return lockedObject != null;
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT__LOCKING_THREAD:
				return lockingThread != null;
		}
		return super.eIsSet(featureID);
	}

} //TRCThreadWaitingForLockEventImpl
