/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCThreadWaitingForObjectEventImpl.java,v 1.8 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Thread Waiting For Object Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForObjectEventImpl#getTimeout <em>Timeout</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCThreadWaitingForObjectEventImpl#getObjectWaitingFor <em>Object Waiting For</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCThreadWaitingForObjectEventImpl extends TRCThreadEventImpl implements TRCThreadWaitingForObjectEvent {
	/**
	 * The default value of the '{@link #getTimeout() <em>Timeout</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeout()
	 * @generated
	 * @ordered
	 */
	protected static final long TIMEOUT_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTimeout() <em>Timeout</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeout()
	 * @generated
	 * @ordered
	 */
	protected long timeout = TIMEOUT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getObjectWaitingFor() <em>Object Waiting For</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObjectWaitingFor()
	 * @generated
	 * @ordered
	 */
	protected TRCObject objectWaitingFor;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCThreadWaitingForObjectEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_THREAD_WAITING_FOR_OBJECT_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTimeout() {
		return timeout;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimeout(long newTimeout) {
		long oldTimeout = timeout;
		timeout = newTimeout;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT, oldTimeout, timeout));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getObjectWaitingFor() {
		if (objectWaitingFor != null && objectWaitingFor.eIsProxy()) {
			InternalEObject oldObjectWaitingFor = (InternalEObject)objectWaitingFor;
			objectWaitingFor = (TRCObject)eResolveProxy(oldObjectWaitingFor);
			if (objectWaitingFor != oldObjectWaitingFor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR, oldObjectWaitingFor, objectWaitingFor));
			}
		}
		return objectWaitingFor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetObjectWaitingFor() {
		return objectWaitingFor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setObjectWaitingFor(TRCObject newObjectWaitingFor) {
		TRCObject oldObjectWaitingFor = objectWaitingFor;
		objectWaitingFor = newObjectWaitingFor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR, oldObjectWaitingFor, objectWaitingFor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT:
				return getTimeout();
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR:
				if (resolve) return getObjectWaitingFor();
				return basicGetObjectWaitingFor();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT:
				setTimeout((Long)newValue);
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR:
				setObjectWaitingFor((TRCObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT:
				setTimeout(TIMEOUT_EDEFAULT);
				return;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR:
				setObjectWaitingFor((TRCObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__TIMEOUT:
				return timeout != TIMEOUT_EDEFAULT;
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT__OBJECT_WAITING_FOR:
				return objectWaitingFor != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (timeout: ");
		result.append(timeout);
		result.append(')');
		return result.toString();
	}

} //TRCThreadWaitingForObjectEventImpl
