/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCTypedObjectValueImpl.java,v 1.9 2009/05/05 15:46:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCObjectValueKind;
import org.eclipse.hyades.models.trace.TRCObjectValuePosition;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Typed Object Value</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl#getValueKind <em>Value Kind</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl#getPositionKind <em>Position Kind</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl#getPosition <em>Position</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl#getObject <em>Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCTypedObjectValueImpl extends TRCObjectValueImpl implements TRCTypedObjectValue {
	/**
	 * The default value of the '{@link #getValueKind() <em>Value Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueKind()
	 * @generated
	 * @ordered
	 */
	protected static final TRCObjectValueKind VALUE_KIND_EDEFAULT = TRCObjectValueKind.THIS_LITERAL;

	/**
	 * The cached value of the '{@link #getValueKind() <em>Value Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueKind()
	 * @generated
	 * @ordered
	 */
	protected TRCObjectValueKind valueKind = VALUE_KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #getPositionKind() <em>Position Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPositionKind()
	 * @generated
	 * @ordered
	 */
	protected static final TRCObjectValuePosition POSITION_KIND_EDEFAULT = TRCObjectValuePosition.BEFORE_LITERAL;

	/**
	 * The cached value of the '{@link #getPositionKind() <em>Position Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPositionKind()
	 * @generated
	 * @ordered
	 */
	protected TRCObjectValuePosition positionKind = POSITION_KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #getPosition() <em>Position</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPosition()
	 * @generated
	 * @ordered
	 */
	protected static final short POSITION_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPosition() <em>Position</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPosition()
	 * @generated
	 * @ordered
	 */
	protected short position = POSITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getObject() <em>Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObject()
	 * @generated
	 * @ordered
	 */
	protected TRCTraceObject object;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCTypedObjectValueImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TracePackage.Literals.TRC_TYPED_OBJECT_VALUE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectValueKind getValueKind() {
		return valueKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValueKind(TRCObjectValueKind newValueKind) {
		TRCObjectValueKind oldValueKind = valueKind;
		valueKind = newValueKind == null ? VALUE_KIND_EDEFAULT : newValueKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND, oldValueKind, valueKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectValuePosition getPositionKind() {
		return positionKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPositionKind(TRCObjectValuePosition newPositionKind) {
		TRCObjectValuePosition oldPositionKind = positionKind;
		positionKind = newPositionKind == null ? POSITION_KIND_EDEFAULT : newPositionKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND, oldPositionKind, positionKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getPosition() {
		return position;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPosition(short newPosition) {
		short oldPosition = position;
		position = newPosition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION, oldPosition, position));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject getObject() {
		if (object != null && object.eIsProxy()) {
			InternalEObject oldObject = (InternalEObject)object;
			object = (TRCTraceObject)eResolveProxy(oldObject);
			if (object != oldObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT, oldObject, object));
			}
		}
		return object;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject basicGetObject() {
		return object;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setObject(TRCTraceObject newObject) {
		TRCTraceObject oldObject = object;
		object = newObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT, oldObject, object));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND:
				return getValueKind();
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND:
				return getPositionKind();
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION:
				return getPosition();
			case TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT:
				if (resolve) return getObject();
				return basicGetObject();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND:
				setValueKind((TRCObjectValueKind)newValue);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND:
				setPositionKind((TRCObjectValuePosition)newValue);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION:
				setPosition((Short)newValue);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT:
				setObject((TRCTraceObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND:
				setValueKind(VALUE_KIND_EDEFAULT);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND:
				setPositionKind(POSITION_KIND_EDEFAULT);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION:
				setPosition(POSITION_EDEFAULT);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT:
				setObject((TRCTraceObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND:
				return valueKind != VALUE_KIND_EDEFAULT;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND:
				return positionKind != POSITION_KIND_EDEFAULT;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION:
				return position != POSITION_EDEFAULT;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT:
				return object != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (valueKind: ");
		result.append(valueKind);
		result.append(", positionKind: ");
		result.append(positionKind);
		result.append(", position: ");
		result.append(position);
		result.append(')');
		return result.toString();
	}

} //TRCTypedObjectValueImpl
