/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TraceSwitch.java,v 1.15 2009/05/05 15:51:13 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.trace.util;

import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCGCEvent;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCLLData;
import org.eclipse.hyades.models.trace.TRCLanguageElement;
import org.eclipse.hyades.models.trace.TRCLineCoverageData;
import org.eclipse.hyades.models.trace.TRCLinePerformanceData;
import org.eclipse.hyades.models.trace.TRCLockAccess;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodWithLLData;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation;
import org.eclipse.hyades.models.trace.TRCObjectAllocationSite;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadExecEvent;
import org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitTimeoutExceedEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.trace.TracePackage
 * @generated
 */
public class TraceSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static TracePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TraceSwitch() {
		if (modelPackage == null) {
			modelPackage = TracePackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case TracePackage.TRCGC_EVENT: {
				TRCGCEvent trcgcEvent = (TRCGCEvent)theEObject;
				T result = caseTRCGCEvent(trcgcEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT: {
				TRCObject trcObject = (TRCObject)theEObject;
				T result = caseTRCObject(trcObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_CLASS: {
				TRCClass trcClass = (TRCClass)theEObject;
				T result = caseTRCClass(trcClass);
				if (result == null) result = caseTRCLanguageElement(trcClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_METHOD_INVOCATION: {
				TRCMethodInvocation trcMethodInvocation = (TRCMethodInvocation)theEObject;
				T result = caseTRCMethodInvocation(trcMethodInvocation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_PROCESS: {
				TRCProcess trcProcess = (TRCProcess)theEObject;
				T result = caseTRCProcess(trcProcess);
				if (result == null) result = caseAbstractTRCProcess(trcProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD: {
				TRCThread trcThread = (TRCThread)theEObject;
				T result = caseTRCThread(trcThread);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_METHOD: {
				TRCMethod trcMethod = (TRCMethod)theEObject;
				T result = caseTRCMethod(trcMethod);
				if (result == null) result = caseTRCLanguageElement(trcMethod);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_PACKAGE: {
				TRCPackage trcPackage = (TRCPackage)theEObject;
				T result = caseTRCPackage(trcPackage);
				if (result == null) result = caseTRCLanguageElement(trcPackage);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_COLLECTION_BOUNDARY: {
				TRCCollectionBoundary trcCollectionBoundary = (TRCCollectionBoundary)theEObject;
				T result = caseTRCCollectionBoundary(trcCollectionBoundary);
				if (result == null) result = caseAbstractTRCCollectionBoundary(trcCollectionBoundary);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_CLASS_LOADER: {
				TRCClassLoader trcClassLoader = (TRCClassLoader)theEObject;
				T result = caseTRCClassLoader(trcClassLoader);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_SOURCE_INFO: {
				TRCSourceInfo trcSourceInfo = (TRCSourceInfo)theEObject;
				T result = caseTRCSourceInfo(trcSourceInfo);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_HEAP_OBJECT: {
				TRCHeapObject trcHeapObject = (TRCHeapObject)theEObject;
				T result = caseTRCHeapObject(trcHeapObject);
				if (result == null) result = caseTRCObject(trcHeapObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_FULL_TRACE_OBJECT: {
				TRCFullTraceObject trcFullTraceObject = (TRCFullTraceObject)theEObject;
				T result = caseTRCFullTraceObject(trcFullTraceObject);
				if (result == null) result = caseTRCTraceObject(trcFullTraceObject);
				if (result == null) result = caseTRCObject(trcFullTraceObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_TRACE_OBJECT: {
				TRCTraceObject trcTraceObject = (TRCTraceObject)theEObject;
				T result = caseTRCTraceObject(trcTraceObject);
				if (result == null) result = caseTRCObject(trcTraceObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_FULL_HEAP_OBJECT: {
				TRCFullHeapObject trcFullHeapObject = (TRCFullHeapObject)theEObject;
				T result = caseTRCFullHeapObject(trcFullHeapObject);
				if (result == null) result = caseTRCHeapObject(trcFullHeapObject);
				if (result == null) result = caseTRCObject(trcFullHeapObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_REFERENCE: {
				TRCObjectReference trcObjectReference = (TRCObjectReference)theEObject;
				T result = caseTRCObjectReference(trcObjectReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_HEAP_DUMP: {
				TRCHeapDump trcHeapDump = (TRCHeapDump)theEObject;
				T result = caseTRCHeapDump(trcHeapDump);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION: {
				TRCAggregatedMethodInvocation trcAggregatedMethodInvocation = (TRCAggregatedMethodInvocation)theEObject;
				T result = caseTRCAggregatedMethodInvocation(trcAggregatedMethodInvocation);
				if (result == null) result = caseTRCMethodInvocation(trcAggregatedMethodInvocation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_FULL_METHOD_INVOCATION: {
				TRCFullMethodInvocation trcFullMethodInvocation = (TRCFullMethodInvocation)theEObject;
				T result = caseTRCFullMethodInvocation(trcFullMethodInvocation);
				if (result == null) result = caseTRCMethodInvocation(trcFullMethodInvocation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_HEAP_ROOT: {
				TRCHeapRoot trcHeapRoot = (TRCHeapRoot)theEObject;
				T result = caseTRCHeapRoot(trcHeapRoot);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_ARRAY_CLASS: {
				TRCArrayClass trcArrayClass = (TRCArrayClass)theEObject;
				T result = caseTRCArrayClass(trcArrayClass);
				if (result == null) result = caseTRCClass(trcArrayClass);
				if (result == null) result = caseTRCLanguageElement(trcArrayClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE: {
				TRCAggregatedObjectReference trcAggregatedObjectReference = (TRCAggregatedObjectReference)theEObject;
				T result = caseTRCAggregatedObjectReference(trcAggregatedObjectReference);
				if (result == null) result = caseTRCObjectReference(trcAggregatedObjectReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_EVENT: {
				TRCThreadEvent trcThreadEvent = (TRCThreadEvent)theEObject;
				T result = caseTRCThreadEvent(trcThreadEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_SLEEPING_EVENT: {
				TRCThreadSleepingEvent trcThreadSleepingEvent = (TRCThreadSleepingEvent)theEObject;
				T result = caseTRCThreadSleepingEvent(trcThreadSleepingEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadSleepingEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT: {
				TRCThreadWaitingForObjectEvent trcThreadWaitingForObjectEvent = (TRCThreadWaitingForObjectEvent)theEObject;
				T result = caseTRCThreadWaitingForObjectEvent(trcThreadWaitingForObjectEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadWaitingForObjectEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT: {
				TRCThreadWaitingForLockEvent trcThreadWaitingForLockEvent = (TRCThreadWaitingForLockEvent)theEObject;
				T result = caseTRCThreadWaitingForLockEvent(trcThreadWaitingForLockEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadWaitingForLockEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_RUNNING_EVENT: {
				TRCThreadRunningEvent trcThreadRunningEvent = (TRCThreadRunningEvent)theEObject;
				T result = caseTRCThreadRunningEvent(trcThreadRunningEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadRunningEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_DEAD_EVENT: {
				TRCThreadDeadEvent trcThreadDeadEvent = (TRCThreadDeadEvent)theEObject;
				T result = caseTRCThreadDeadEvent(trcThreadDeadEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadDeadEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_METHOD_WITH_LL_DATA: {
				TRCMethodWithLLData trcMethodWithLLData = (TRCMethodWithLLData)theEObject;
				T result = caseTRCMethodWithLLData(trcMethodWithLLData);
				if (result == null) result = caseTRCMethod(trcMethodWithLLData);
				if (result == null) result = caseTRCLanguageElement(trcMethodWithLLData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRCLL_DATA: {
				TRCLLData trcllData = (TRCLLData)theEObject;
				T result = caseTRCLLData(trcllData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_SOURCE_INFO_WITH_LL_DATA: {
				TRCSourceInfoWithLLData trcSourceInfoWithLLData = (TRCSourceInfoWithLLData)theEObject;
				T result = caseTRCSourceInfoWithLLData(trcSourceInfoWithLLData);
				if (result == null) result = caseTRCSourceInfo(trcSourceInfoWithLLData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_LINE_COVERAGE_DATA: {
				TRCLineCoverageData trcLineCoverageData = (TRCLineCoverageData)theEObject;
				T result = caseTRCLineCoverageData(trcLineCoverageData);
				if (result == null) result = caseTRCLLData(trcLineCoverageData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_VALUE: {
				TRCObjectValue trcObjectValue = (TRCObjectValue)theEObject;
				T result = caseTRCObjectValue(trcObjectValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_INPUT_OUTPUT_ENTRY: {
				@SuppressWarnings("unchecked") Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> trcInputOutputEntry = (Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>>)theEObject;
				T result = caseTRCInputOutputEntry(trcInputOutputEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER: {
				TRCInputOutputContainer trcInputOutputContainer = (TRCInputOutputContainer)theEObject;
				T result = caseTRCInputOutputContainer(trcInputOutputContainer);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO: {
				TRCCallerCalleeInvocationInfo trcCallerCalleeInvocationInfo = (TRCCallerCalleeInvocationInfo)theEObject;
				T result = caseTRCCallerCalleeInvocationInfo(trcCallerCalleeInvocationInfo);
				if (result == null) result = caseTRCFullMethodInvocation(trcCallerCalleeInvocationInfo);
				if (result == null) result = caseTRCMethodInvocation(trcCallerCalleeInvocationInfo);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_TYPED_OBJECT_VALUE: {
				TRCTypedObjectValue trcTypedObjectValue = (TRCTypedObjectValue)theEObject;
				T result = caseTRCTypedObjectValue(trcTypedObjectValue);
				if (result == null) result = caseTRCObjectValue(trcTypedObjectValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_MTHD_LCK_ACC_ENTRY: {
				@SuppressWarnings("unchecked") Map.Entry<TRCMethodInvocation, EList<TRCLockAccess>> trcMthdLckAccEntry = (Map.Entry<TRCMethodInvocation, EList<TRCLockAccess>>)theEObject;
				T result = caseTRCMthdLckAccEntry(trcMthdLckAccEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_LOCK_ACCESS: {
				TRCLockAccess trcLockAccess = (TRCLockAccess)theEObject;
				T result = caseTRCLockAccess(trcLockAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_LINE_PERFORMANCE_DATA: {
				TRCLinePerformanceData trcLinePerformanceData = (TRCLinePerformanceData)theEObject;
				T result = caseTRCLinePerformanceData(trcLinePerformanceData);
				if (result == null) result = caseTRCLineCoverageData(trcLinePerformanceData);
				if (result == null) result = caseTRCLLData(trcLinePerformanceData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_ALLOCATION_SITES_ENTRY: {
				@SuppressWarnings("unchecked") Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>> trcObjectAllocationSitesEntry = (Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>>)theEObject;
				T result = caseTRCObjectAllocationSitesEntry(trcObjectAllocationSitesEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE: {
				TRCObjectAllocationSite trcObjectAllocationSite = (TRCObjectAllocationSite)theEObject;
				T result = caseTRCObjectAllocationSite(trcObjectAllocationSite);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT: {
				TRCThreadDeadLockEvent trcThreadDeadLockEvent = (TRCThreadDeadLockEvent)theEObject;
				T result = caseTRCThreadDeadLockEvent(trcThreadDeadLockEvent);
				if (result == null) result = caseTRCThreadWaitingForLockEvent(trcThreadDeadLockEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadDeadLockEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_LANGUAGE_ELEMENT: {
				TRCLanguageElement trcLanguageElement = (TRCLanguageElement)theEObject;
				T result = caseTRCLanguageElement(trcLanguageElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_ALLOCATION_ANNOTATION: {
				TRCObjectAllocationAnnotation trcObjectAllocationAnnotation = (TRCObjectAllocationAnnotation)theEObject;
				T result = caseTRCObjectAllocationAnnotation(trcObjectAllocationAnnotation);
				if (result == null) result = caseTRCAnnotation(trcObjectAllocationAnnotation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_WAIT_TIMEOUT_EXCEED_EVENT: {
				TRCThreadWaitTimeoutExceedEvent trcThreadWaitTimeoutExceedEvent = (TRCThreadWaitTimeoutExceedEvent)theEObject;
				T result = caseTRCThreadWaitTimeoutExceedEvent(trcThreadWaitTimeoutExceedEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadWaitTimeoutExceedEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_WAITING_FOR_JOIN_EVENT: {
				TRCThreadWaitingForJoinEvent trcThreadWaitingForJoinEvent = (TRCThreadWaitingForJoinEvent)theEObject;
				T result = caseTRCThreadWaitingForJoinEvent(trcThreadWaitingForJoinEvent);
				if (result == null) result = caseTRCThreadWaitingForObjectEvent(trcThreadWaitingForJoinEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadWaitingForJoinEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_EXEC_EVENT: {
				TRCThreadExecEvent trcThreadExecEvent = (TRCThreadExecEvent)theEObject;
				T result = caseTRCThreadExecEvent(trcThreadExecEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadExecEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_NOTIFY_ALL_EVENT: {
				TRCThreadNotifyAllEvent trcThreadNotifyAllEvent = (TRCThreadNotifyAllEvent)theEObject;
				T result = caseTRCThreadNotifyAllEvent(trcThreadNotifyAllEvent);
				if (result == null) result = caseTRCThreadExecEvent(trcThreadNotifyAllEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadNotifyAllEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_NOTIFY_EVENT: {
				TRCThreadNotifyEvent trcThreadNotifyEvent = (TRCThreadNotifyEvent)theEObject;
				T result = caseTRCThreadNotifyEvent(trcThreadNotifyEvent);
				if (result == null) result = caseTRCThreadExecEvent(trcThreadNotifyEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadNotifyEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_DEAD_AND_NOTIFY_JOINED_EVENT: {
				TRCThreadDeadAndNotifyJoinedEvent trcThreadDeadAndNotifyJoinedEvent = (TRCThreadDeadAndNotifyJoinedEvent)theEObject;
				T result = caseTRCThreadDeadAndNotifyJoinedEvent(trcThreadDeadAndNotifyJoinedEvent);
				if (result == null) result = caseTRCThreadExecEvent(trcThreadDeadAndNotifyJoinedEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadDeadAndNotifyJoinedEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_START_THREAD_EVENT: {
				TRCThreadStartThreadEvent trcThreadStartThreadEvent = (TRCThreadStartThreadEvent)theEObject;
				T result = caseTRCThreadStartThreadEvent(trcThreadStartThreadEvent);
				if (result == null) result = caseTRCThreadExecEvent(trcThreadStartThreadEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadStartThreadEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_INTERRUPT_THREAD_EVENT: {
				TRCThreadInterruptThreadEvent trcThreadInterruptThreadEvent = (TRCThreadInterruptThreadEvent)theEObject;
				T result = caseTRCThreadInterruptThreadEvent(trcThreadInterruptThreadEvent);
				if (result == null) result = caseTRCThreadExecEvent(trcThreadInterruptThreadEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadInterruptThreadEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_HANDOFF_LOCK_EVENT: {
				TRCThreadHandoffLockEvent trcThreadHandoffLockEvent = (TRCThreadHandoffLockEvent)theEObject;
				T result = caseTRCThreadHandoffLockEvent(trcThreadHandoffLockEvent);
				if (result == null) result = caseTRCThreadExecEvent(trcThreadHandoffLockEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadHandoffLockEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCObject(TRCObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCClass(TRCClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Method Invocation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Method Invocation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCMethodInvocation(TRCMethodInvocation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCProcess(TRCProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThread(TRCThread object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Method</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Method</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCMethod(TRCMethod object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Package</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Package</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCPackage(TRCPackage object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Collection Boundary</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Collection Boundary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCCollectionBoundary(TRCCollectionBoundary object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Class Loader</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Class Loader</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCClassLoader(TRCClassLoader object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Source Info</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Source Info</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCSourceInfo(TRCSourceInfo object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Heap Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Heap Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCHeapObject(TRCHeapObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Full Trace Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Full Trace Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCFullTraceObject(TRCFullTraceObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Trace Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Trace Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCTraceObject(TRCTraceObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Full Heap Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Full Heap Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCFullHeapObject(TRCFullHeapObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Object Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Object Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCObjectReference(TRCObjectReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Heap Dump</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Heap Dump</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCHeapDump(TRCHeapDump object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Aggregated Method Invocation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Aggregated Method Invocation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCAggregatedMethodInvocation(TRCAggregatedMethodInvocation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Full Method Invocation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Full Method Invocation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCFullMethodInvocation(TRCFullMethodInvocation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Heap Root</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Heap Root</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCHeapRoot(TRCHeapRoot object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Array Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Array Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCArrayClass(TRCArrayClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Aggregated Object Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Aggregated Object Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCAggregatedObjectReference(TRCAggregatedObjectReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadEvent(TRCThreadEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Sleeping Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Sleeping Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadSleepingEvent(TRCThreadSleepingEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Waiting For Object Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Waiting For Object Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadWaitingForObjectEvent(TRCThreadWaitingForObjectEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Waiting For Lock Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Waiting For Lock Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadWaitingForLockEvent(TRCThreadWaitingForLockEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Running Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Running Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadRunningEvent(TRCThreadRunningEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Dead Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Dead Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadDeadEvent(TRCThreadDeadEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Method With LL Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Method With LL Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCMethodWithLLData(TRCMethodWithLLData object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRCLL Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRCLL Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCLLData(TRCLLData object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Source Info With LL Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Source Info With LL Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCSourceInfoWithLLData(TRCSourceInfoWithLLData object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Line Coverage Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Line Coverage Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCLineCoverageData(TRCLineCoverageData object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Object Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Object Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCObjectValue(TRCObjectValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Input Output Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Input Output Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCInputOutputEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectValue>> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Input Output Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Input Output Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCInputOutputContainer(TRCInputOutputContainer object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Caller Callee Invocation Info</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Caller Callee Invocation Info</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCCallerCalleeInvocationInfo(TRCCallerCalleeInvocationInfo object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Typed Object Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Typed Object Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCTypedObjectValue(TRCTypedObjectValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Mthd Lck Acc Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Mthd Lck Acc Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCMthdLckAccEntry(Map.Entry<TRCMethodInvocation, EList<TRCLockAccess>> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Lock Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Lock Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCLockAccess(TRCLockAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Line Performance Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Line Performance Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCLinePerformanceData(TRCLinePerformanceData object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Object Allocation Sites Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Object Allocation Sites Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCObjectAllocationSitesEntry(Map.Entry<TRCMethodInvocation, EList<TRCObjectAllocationSite>> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Object Allocation Site</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Object Allocation Site</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCObjectAllocationSite(TRCObjectAllocationSite object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Dead Lock Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Dead Lock Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadDeadLockEvent(TRCThreadDeadLockEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Language Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Language Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCLanguageElement(TRCLanguageElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRCGC Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRCGC Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCGCEvent(TRCGCEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Object Allocation Annotation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Object Allocation Annotation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCObjectAllocationAnnotation(TRCObjectAllocationAnnotation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Wait Timeout Exceed Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Wait Timeout Exceed Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadWaitTimeoutExceedEvent(TRCThreadWaitTimeoutExceedEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Waiting For Join Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Waiting For Join Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadWaitingForJoinEvent(TRCThreadWaitingForJoinEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Exec Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Exec Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadExecEvent(TRCThreadExecEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Notify All Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Notify All Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadNotifyAllEvent(TRCThreadNotifyAllEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Notify Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Notify Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadNotifyEvent(TRCThreadNotifyEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Dead And Notify Joined Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Dead And Notify Joined Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadDeadAndNotifyJoinedEvent(TRCThreadDeadAndNotifyJoinedEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Start Thread Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Start Thread Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadStartThreadEvent(TRCThreadStartThreadEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Interrupt Thread Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Interrupt Thread Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadInterruptThreadEvent(TRCThreadInterruptThreadEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Thread Handoff Lock Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Thread Handoff Lock Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCThreadHandoffLockEvent(TRCThreadHandoffLockEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract TRC Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract TRC Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractTRCProcess(AbstractTRCProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract TRC Collection Boundary</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract TRC Collection Boundary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractTRCCollectionBoundary(AbstractTRCCollectionBoundary object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRC Annotation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRC Annotation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRCAnnotation(TRCAnnotation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //TraceSwitch
