/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IServerProfileExtender.java,v 1.1 2007/04/23 20:03:43 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.profile.server.wst;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

/**
 * A server profiler extender.
 * @author ewchan
 */
public interface IServerProfileExtender {

	/**
	 * Processes the launch configuration elements about to be run in profile mode.
	 * @param launch the launch
	 * @param vmInstall the vm install being run against
	 * @param vmConfig the configuration to process
	 * @param monitor a progress monitor
	 */
	public void process(ILaunch launch, IVMInstall vmInstall, VMRunnerConfiguration vmConfig, IProgressMonitor monitor);
}
