/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileOnServerOptionWizard.java,v 1.1 2007/04/23 03:26:34 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.wst.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;

/**
 * 
 * @author ewchan
 *
 */
public class ProfileOnServerOptionWizard extends Wizard implements IPluginContribution {

	private ProfileOnServerOptionWizardPage _page;
	private ILaunchConfigurationWorkingCopy _wc;
	
	public ProfileOnServerOptionWizard(ILaunchConfigurationWorkingCopy workingCopy) {
		super();
		_wc = workingCopy;
	}

	public String getLocalId() {
		return "org.eclipse.tptp.platform.profile.server.wst.internal.ProfileOnServerOptionWizard"; //$NON-NLS-1$
	}
	
	public String getPluginId() {
		return ServerPlugin.getDefault().getBundle().getSymbolicName();
	}
	
	public void addPages() {
		setWindowTitle(PluginMessages._1);  //$NON-NLS-1$
		_page = new ProfileOnServerOptionWizardPage("org.eclipse.tptp.platform.profile.server.wst.internal.ProfileOnServerOptionWizardPage", _wc); //$NON-NLS-1$
		addPage(_page);
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
	}

	public boolean performFinish() {
		boolean result = _page.finish();
		try {
			_wc.doSave();
		}
		catch (CoreException e) {
			e.printStackTrace();
		}
		return result;
	}
}
