/**********************************************************************
 * Copyright (c) 2007, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileOnServerOptionWizardPage.java,v 1.4 2010/12/07 15:11:57 mreid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.wst.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.DestinationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.HyadesTraceUIExtensionSupportUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/**
 * 
 * @author ewchan
 *
 */
public class ProfileOnServerOptionWizardPage extends WizardPage {

	private ILaunchConfigurationTab[] tabList;
	private ILaunchConfigurationWorkingCopy workingCopy;
	private boolean widgetCreated = false; 

	public ProfileOnServerOptionWizardPage(String name, ILaunchConfigurationWorkingCopy workingCopy) {
		super(name);
        this.workingCopy = workingCopy;
		setTitle(PluginMessages._1);
		widgetCreated = false;
	}

	/**
	 * Creates the control for this wizard page.
	 * 
	 * @param parent parent's composite
	 */
	public void createControl(Composite parent) {

		GridData data = new GridData(SWT.FILL, SWT.FILL, true, true);
		data.minimumWidth = 600;
		data.minimumHeight = 430;
		parent.setLayoutData(data);

		Composite content = new Composite(parent, SWT.NONE);
		content.setLayout(new GridLayout());
				
		List list = new ArrayList();
		
		ProfileTab profileTab = new ProfileTab(false)  {
			protected void updateLaunchConfigurationDialog() {
				updateDialog();
			}
		};
		DestinationTab destinationTab = new DestinationTab() {
			protected void updateLaunchConfigurationDialog() {
				updateDialog();
			}
		};
		list.add(profileTab);
		list.add(destinationTab);

		// Provide profiling dialogue tab list to interested extensions (Bug 323330)
		HyadesTraceUIExtensionSupportUtil.addOrInformExtensionTabs(list, ProfileOnServerOptionWizardPage.class);
		
		tabList = new ILaunchConfigurationTab[list.size()];
		list.toArray(tabList);		
		
		TabFolder folder = new TabFolder(content, SWT.TOP);
		data = new GridData(SWT.FILL, SWT.FILL, true, true);
		data.grabExcessHorizontalSpace = true;
		data.grabExcessVerticalSpace = true;
		data.minimumWidth = 450;
		folder.setLayoutData(data);
		folder.addSelectionListener( new SelectionListener() {
			
			// Bug 323137 - Call activated when the tab has been selected
			public void widgetSelected(SelectionEvent ev) {
				
				TabItem item = (ev.item instanceof TabItem) ? (TabItem)ev.item : null;
				if( isCurrentPage() && null != item && getProfileTab().getControl() == item.getControl() )
					getProfileTab().activated(workingCopy);
				
			}
			
			public void widgetDefaultSelected(SelectionEvent ev) {
				
				// Don't care about this event
				
			}
			
		});
		
		for(int i = 0; i < tabList.length; i ++) {
			TabItem tab = new TabItem(folder, SWT.TOP);
			tabList[i].createControl(folder);
			tab.setText(tabList[i].getName());
			tab.setImage(tabList[i].getImage());
			tab.setControl(tabList[i].getControl());
		}

		initialize();
		setMessage(PluginMessages._2);

		widgetCreated = true;
		
		setControl(content);
		parent.pack();
		
		// Bug 323137 - Send the 'activated' event to the profile tab when this page is visited
		if( this.getContainer() instanceof WizardDialog ) {
		
			WizardDialog dialog = (WizardDialog)this.getContainer();
			dialog.addPageChangedListener(new IPageChangedListener() {
				public void pageChanged(PageChangedEvent ev) {
					if( ev.getSelectedPage() == ProfileOnServerOptionWizardPage.this )
						getProfileTab().activated(workingCopy);
				}
			});
			
		}
	}

	public void initialize() {
		for(int i = 0; i < tabList.length; i ++) {
				tabList[i].initializeFrom(workingCopy);
		}
	}

	public boolean finish() {
		for(int i = 0; i < tabList.length; i ++) {
			tabList[i].performApply(workingCopy);
		}
		return true;
	}

	public boolean isPageComplete() {
		
		// Bug 323137 - Let the profile tab figure out if its valid
		return getProfileTab().isValid(workingCopy) && getDestinationTab().isValid(workingCopy);

	}
	
	
	/** Locate the profile tab in the tab list*/
	private ProfileTab getProfileTab() {
		for(int x = 0; x < tabList.length; x++) {
			
			if(tabList[x] instanceof ProfileTab) {
				return (ProfileTab)tabList[x];
			}
		}
		return null;
	}
	
	/** Locate the destination tab in the tab list*/
	private DestinationTab getDestinationTab() {
		for(int x = 0; x < tabList.length; x++) {
			
			if(tabList[x] instanceof DestinationTab) {
				return (DestinationTab)tabList[x];
			}
		}
		return null;
	}
	
	public void updateDialog() {

		if (!widgetCreated) return;
		
		setPageComplete(isPageComplete());

		String errorMsg = null;

		IStatus status = ProfileLaunchUtil.checkValidity(workingCopy, (getProfileTab()).getProfileUI().getCheckBoxTreeViewer(),new ProfilingSetsManagerCopy());
		if (status.getSeverity()==IStatus.ERROR) {
			errorMsg = "[" + LegacyActionTools.removeMnemonics(tabList[0].getName()) + "] " + status.getMessage(); //$NON-NLS-1$ //$NON-NLS-2$
		}
		else if (getDestinationTab().getErrorMessage()!=null) {
			errorMsg = "[" + LegacyActionTools.removeMnemonics(tabList[1].getName()) + "] " + tabList[1].getErrorMessage(); //$NON-NLS-1$ //$NON-NLS-2$
		}
		
		setErrorMessage(errorMsg);
	}
}
