/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ServerPlugin.java,v 1.3 2007/04/27 16:42:04 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.profile.server.wst.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class ServerPlugin extends AbstractUIPlugin {

    //The shared instance.
	private static ServerPlugin plugin;
	
	// cached copy of all server profile extenders
	private static List serverProfileExtenders;
	
	private static final String PLUGIN_ID = "org.eclipse.tptp.platform.profile.server.wst";

	
	/**
	 * The constructor.
	 */
	public ServerPlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static ServerPlugin getDefault() {
		return plugin;
	}

	public static String getPluginId() {
		return PLUGIN_ID;
	}
	
	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin(getDefault().getBundle().getSymbolicName(), path);
	}

    /**
     * Returns the string from the plugin's resource bundle,
     * or 'key' if not found.
     */
    public static String getResourceString(String key) {
        ResourceBundle resource = Platform.getResourceBundle(getDefault().getBundle());
        try {
            return resource.getString(key);
        } catch (MissingResourceException e) {
            return key;
        }
    }
    
    /**
     * Logs a message in the workspace log file with the given severity.
     * 
     * @param severity The severity of the error or exception
     * @param throwable The error or exception
     */
    public static void log(int severity, Throwable throwable) {
        Status status = new Status(severity, plugin.getBundle().getSymbolicName(), 0, throwable.toString(), throwable);
        plugin.getLog().log(status);
    }
    
	public static void logError(Throwable throwable) {
		Status status = new Status(Status.ERROR, plugin.getBundle().getSymbolicName(), 0, throwable.toString(), throwable);
		plugin.getLog().log(status);
	}
	
	/**
	 * Returns an array of all known server profiler instances.
	 * <p>
	 * A new array is returned on each call, so clients may store or modify the result.
	 * </p>
	 * 
	 * @return a possibly-empty array of server profiler instances
	 *    {@link ServerProfileExtender}
	 */
	public static ServerProfileExtender[] getServerProfileExtenders() {
		if (serverProfileExtenders == null)
			loadServerProfileExtenders();
		
		ServerProfileExtender[] sp = new ServerProfileExtender[serverProfileExtenders.size()];
		serverProfileExtenders.toArray(sp);
		return sp;
	}
	
	private static synchronized void loadServerProfileExtenders() {
		if (serverProfileExtenders != null)
			return;
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IConfigurationElement[] cf = registry.getConfigurationElementsFor(ServerPlugin.PLUGIN_ID, "serverProfileExtenders");
		
		int size = cf.length;
		List list = new ArrayList(size);
		for (int i = 0; i < size; i++) {
			try {
				list.add(new ServerProfileExtender(cf[i]));
			} catch (Throwable t) {
			}
		}
		serverProfileExtenders = list;
	}
}
