/*******************************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.profile.server.wst.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.tptp.platform.profile.server.wst.IServerProfileExtender;
/**
 * @author ewchan
 * @see org.eclipse.jst.server.core.internal.ServerProfiler
 */
public class ServerProfileExtender {
	private IConfigurationElement element;
	private IServerProfileExtender extender;

	/**
	 * Create a new server profile extender.
	 * 
	 * @param element a configuration element
	 */
	public ServerProfileExtender(IConfigurationElement element) {
		super();
		this.element = element;
	}

	/**
	 * 
	 * @return the id
	 */
	public String getId() {
		return element.getAttribute("id");
	}

	/**
	 * 
	 * @return the name
	 */
	public String getName() {
		return element.getAttribute("name");
	}

	/*
	 * Loads the delegate class.
	 */
	protected IServerProfileExtender getExtender() {
		if (extender == null) {
			if (element.getAttribute("class") == null)
				return null;
			try {
				extender = (IServerProfileExtender) element.createExecutableExtension("class");
			} catch (Throwable t) {
				ServerPlugin.logError(new Exception("Could not create delegate " + toString() + ": " + t.getMessage()));
			}
		}
		return extender;
	}

	public void process(ILaunch launch, IVMInstall vmInstall, VMRunnerConfiguration vmConfig, IProgressMonitor monitor) {
		try {
			IServerProfileExtender extender = getExtender();
			if (extender != null)
				extender.process(launch, vmInstall, vmConfig, monitor);
		} catch (Throwable t) {
			ServerPlugin.logError(new Exception("Could not create delegate " + toString() + ": " + t.getMessage()));
		}
	}

	public String toString() {
		return "ServerProfileExtender[" + getId() + "]";
	}
}