/*******************************************************************************
 * Copyright (c) 2007, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.profile.server.wst.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.internal.launcher.HyadesTraceUIExtensionSupportUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop;
import org.eclipse.tptp.platform.profile.server.core.internal.IProfileServerConstants;
import org.eclipse.tptp.platform.profile.server.wst.provisional.ServerProfilingUtils;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorBaseLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.IParameterExtractor;

public class TPTPServerProfilerDelegate extends ServerProfilerDelegate{

	private String[] vm_arg;
//	private ILaunchConfigurationWorkingCopy wc;
	private ILaunch launch;
	private IProgressMonitor monitor;
	
	protected String[] processVMArgs(String[] vmArgs, final ILaunchConfigurationWorkingCopy wc) {
		
		/*
		 * There are two dialogs possibily shown during profile on server process, 
		 * 1. launch dialog : is shown before server is started in profiling mode, this dialog is for user to pick the 
		 * 						agent type (PI or TI) and as well select analysis type.
		 * 2. attach dialog : is shown after server is started in profiling mode with a profiling agent associated, and 
		 * 						analysis type of the agent type available is available.
		 * 
		 * launch dialog is shown for user to pick the data collector and analysis type, the options are then persisted
		 * and reapplied in the attach step, attach dialog is shown when there are decision needs to be made by user. ie.
		 * multiple data collector is deteched on server host, or it will be skipped from showning, and options are set 
		 * behide the cover.
		 */
		
		Display.getDefault().syncExec(new Runnable()
		{
			public void run()
			{
					vm_arg = getVMArgsFromUser(wc);
			}
		});				
		
		if (vm_arg!=null)	{
			String[] s;
			s = new String[vmArgs.length + vm_arg.length];
			System.arraycopy(vm_arg, 0, s, 0,vm_arg.length);
			System.arraycopy(vmArgs, 0, s, vm_arg.length, vmArgs.length);
			return s;
		}
		
		return vmArgs;
	}
	
	/*
	 * remove any leading spaces in a string
	 */
	protected String trimLeadingSpaces(String str) {
		String result = str;
		while (result.startsWith(" ")) {
			result = result.substring(1, result.length());
		}
		return result;
	}
	
	protected String[] getVMArgsFromUser(ILaunchConfigurationWorkingCopy wc) {
		ProfileOnServerOptionWizard wizard = new ProfileOnServerOptionWizard(wc);
//        if (!WorkbenchActivityHelper.allowUseOf(null, wizard)) {
//            return "";
//        }
        WizardDialog dialog = new WizardDialog(ServerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), wizard);
        dialog.create();
        dialog.open();
        
    	int wizardReturnCode = dialog.getReturnCode();
    	wc.setAttribute(IProfileServerConstants.SERVER_DIALOG_STATUS, wizardReturnCode);
    	if (wizardReturnCode == Dialog.CANCEL) {
            return null;
        }
    	
		try {
			String collectorOptions = wc.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS,"");
			String[] collectors = collectorOptions.split(";");
			ArrayList list = new ArrayList();
			for (int i=0;i<collectors.length;i++) {
				int idx = collectors[i].indexOf(":");
				if (idx>0) {
					String collectorID = collectors[i].substring(0, idx);
					
					IDataCollectorBaseLauncher delegate = DataCollectorManager.getInstance().getDataCollectorLaunchDelegate(collectorID, wc.getOriginal());
					if (delegate instanceof IParameterExtractor) {
						List paramList = ((IParameterExtractor)delegate).getProcessParameters(wc.getOriginal()).getExecutableParameters();
						if (paramList!=null)
							list.addAll(paramList);
					}	
				}
			}
			String[] vmArgStr = new String[list.size()];
			list.toArray(vmArgStr);
			
			//replace server=controlled with server=enabled for TI vm arguments
			for (int i=0;i<vmArgStr.length;i++) {
				Pattern p = Pattern.compile("server=controlled");
		        Matcher m = p.matcher(vmArgStr[i]); // get a matcher object
		        vmArgStr[i] = m.replaceAll("server=enabled");
		        
		        vmArgStr[i]=vmArgStr[i].trim(); //bug 195367
			}
	        
//			}
			
//			if (collectorOptions.indexOf("org.eclipse.tptp.trace.ui.jvmpiMechanism")>-1)
//			{
//				return IProfileServerConstants.JVM_ARG_PI;
//			}
//			else if (collectorOptions.indexOf("org.eclipse.tptp.trace.jvmti.jvmtiMechanism")>-1) 
//			{
//				if (collectorOptions.indexOf("org.eclipse.tptp.analysisType.jvmti.execution")>-1) {
//					return IProfileServerConstants.JVM_ARG_TI_EXECUTION;
//				}
//				else if (collectorOptions.indexOf("org.eclipse.tptp.analysisType.jvmti.heap")>-1) {
//					return IProfileServerConstants.JVM_ARG_TI_HEAP; 
//				}
//				else if (collectorOptions.indexOf("org.eclipse.tptp.analysisType.jvmti.thread")>-1) {
//					return IProfileServerConstants.JVM_ARG_TI_THREAD;
//				}
//			}
			return vmArgStr;
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
		return null;
	}
	
	public void startAC() {
		if (!AutoStartStop.isIACRunning()) {
			AutoStartStop.startIAC();
		}
	}
	
	public void process(ILaunch launch, IVMInstall vmInstall,VMRunnerConfiguration vmConfig, IProgressMonitor monitor)	throws CoreException {
		this.launch=launch;
		this.monitor=monitor;
		
		
		String[] vmArgs = vmConfig.getVMArguments();
		String[] envcfg = vmConfig.getEnvironment();
		String[] env = ServerProfilingUtils.getEnvironmentVariables();
		
		String jvm_version=IProfileServerConstants.JVM_142; //assume JVM version to 1.4.2 by default.
		IVMInstall2 vmInstall2 = (IVMInstall2)vmInstall;
		if (vmInstall2 != null) {
			jvm_version = vmInstall2.getJavaVersion();
		}
		
		ILaunchConfigurationWorkingCopy wc = launch.getLaunchConfiguration().getWorkingCopy();
				
		wc.setAttribute(IProfileServerConstants.SERVER_JVM_VERSION, jvm_version);
		wc.doSave();
		
		startAC();
		
		//insert profile mode variables
		vmArgs = processVMArgs(vmArgs, wc);

		// If the user cancelled the profile, then throw a CoreException to exit
		if (wc.getAttribute(IProfileServerConstants.SERVER_DIALOG_STATUS, Dialog.CANCEL)==Dialog.CANCEL) {
			throw new CoreException(new Status(IStatus.WARNING,ServerPlugin.getPluginId(),"Profile request is cancelled by user"));
		}

		// Calculate filters
		HyadesTraceUIExtensionSupportUtil.applyExtensionFilterProcessing(wc, LauncherUtility.getActiveWorkingSets());
		
		envcfg = ServerProfilingUtils.map2String(ServerProfilingUtils.processEnvironmentVariables(ServerProfilingUtils.String2map(envcfg), ServerProfilingUtils.String2map(env)));
		
		vmConfig.setVMArguments(vmArgs);
		vmConfig.setEnvironment(envcfg);

		wc.doSave();
		//pass to extension point for extra variable setup
		postProcess(launch, vmInstall, vmConfig, monitor);
	}

	protected void postProcess(ILaunch launch, IVMInstall vmInstall, VMRunnerConfiguration vmConfig, IProgressMonitor monitor) {
		ServerProfileExtender[] extenders = ServerPlugin.getServerProfileExtenders();
		for (int i=0;i<extenders.length;i++) {
			extenders[i].process(launch, vmInstall, vmConfig, monitor);
		}
	}
}
