/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.profile.server.wst.provisional;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.osgi.service.environment.Constants;
import org.eclipse.tptp.platform.iac.administrator.internal.common.AdminUtil;

public class ServerProfilingUtils {

	private static String os = Platform.getOS();

	public static String[] getEnvironmentVariables() {

		String libenv = "";

		if (os.equals(Platform.OS_WIN32)) {
			libenv = "PATH"; //$NON-NLS-1$ //$NON-NLS-2$
		} else if (os.equals(Platform.OS_AIX)) {
			libenv = "LIBPATH"; //$NON-NLS-1$ //$NON-NLS-2$
		} else if (os.equals(Platform.OS_HPUX)) {
			libenv = "SHLIB_PATH"; //$NON-NLS-1$ //$NON-NLS-2$
		} else { // Linux, Solaris
			libenv = "LD_LIBRARY_PATH"; //$NON-NLS-1$ //$NON-NLS-2$
		}

		String pathValue = null;
		String tptpAcHomeValue = null;
		String javaProfilerHomeValue = null;
		String classPathValue = null;

		String iacBinHome = AdminUtil.getIACBinFolder();
		String iacHome = AdminUtil.getIACHome();
		String acHome = AdminUtil.getIACHome();

		if (iacBinHome != null) {
			pathValue = libenv + "=" + iacBinHome + File.pathSeparator
					+ iacHome + File.separator + "lib"; //$NON-NLS-1$ //$NON-NLS-2$
		}

		String jvmTIpath = AdminUtil.getJvmtiNativePath();
		if (jvmTIpath != null) {
			if (pathValue != null) {
				pathValue = pathValue + File.pathSeparator + jvmTIpath;
			} else {
				pathValue = libenv + "=" + jvmTIpath; //$NON-NLS-1$ //$NON-NLS-2$
			}
		}
		
		String probekitPath = AdminUtil.getProbekitNativePath();
		if (probekitPath != null) {
			if (pathValue != null) {
				pathValue = pathValue + File.pathSeparator + probekitPath;
			} else {
				pathValue = libenv + "=" + probekitPath; //$NON-NLS-1$ //$NON-NLS-2$
			}
		}
		
		if (acHome != null) {
			tptpAcHomeValue = "TPTP_AC_HOME=" + acHome; //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (jvmTIpath != null) {
			javaProfilerHomeValue = "JAVA_PROFILER_HOME=" + jvmTIpath; //$NON-NLS-1$ //$NON-NLS-2$
			classPathValue = "CLASSPATH=" + jvmTIpath; //$NON-NLS-1$ //$NON-NLS-2$
		}

		return new String[] { tptpAcHomeValue, javaProfilerHomeValue,
				pathValue, classPathValue };

		// String[] fragmentDirs =
		// EclipseUtility.getFragmentInstallLocations("org.eclipse.hyades.execution");
		// if(fragmentDirs != null) {
		// return new String(libenv+"="+fragmentDirs[0]);
		// }
	}
	
	/*
	 * convert a map to a string array, with each entry equals 'Map.key=Map.value'
	 */
	public static String[] map2String(Map map) {
		if (map==null || map.size()==0) return null;
		
		Map.Entry entry = null;
		Iterator iter = map.entrySet().iterator();
		List strings = new ArrayList(map.size());
		StringBuffer buffer = null;
		while (iter.hasNext()) {
			entry = (Map.Entry) iter.next();
			buffer = new StringBuffer((String) entry.getKey());
			buffer.append('=').append((String) entry.getValue());
			strings.add(buffer.toString());
		}
		return (String[]) strings.toArray(new String[strings.size()]);
	}
	
	/*
	 * convert a string array to a map, with string before char '=' as Map.key and after as Map.value.
	 */
	public static Map String2map(String[] strings) {
		if (strings==null || strings.length==0) return null;
		
		Map map = new HashMap();
		for (int i=0;i<strings.length;i++) {
			String entry = strings[i];
			if (entry!=null) {
				int idx = entry.indexOf("=");
				if (idx>0) { //must have a key, skip otherwise
					String key = strings[i].substring(0,idx);
					String value = strings[i].substring(idx+1,strings[i].length());
					map.put(key, value);
				}
			}
		}
		return map;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.internal.core.LaunchManager#getEnvironment(ILaunchConfiguration)
	 */
	public static Map processEnvironmentVariables(Map envcfgMap, Map envMap) {
		if (envcfgMap==null) {
			envcfgMap = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
		}

		// Add variables from config
		Iterator iter= envMap.entrySet().iterator();
		boolean win32= Platform.getOS().equals(Constants.OS_WIN32);
		Map.Entry entry = null;
		String key = null;
		String value = null;
		Object nativeValue = null;
		Iterator envIter = null;
		Map.Entry nativeEntry = null;
		String nativeKey = null;
		while (iter.hasNext()) {
			entry = (Map.Entry) iter.next();
			key = (String) entry.getKey();
            value = (String) entry.getValue();
            // translate any string substitution variables
            if (value != null) {
                try {
					value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
				} catch (CoreException e) {
					System.err.print("Error substituting environement varilable value :"+value);
					e.printStackTrace();
				}
            }
            boolean added= false;
            nativeValue = envcfgMap.get(key);
            // First, check if the key is an exact match for an existing key.
            if (nativeValue != null) {
                // If an exact match is found, append the value
            	envcfgMap.put(key, value+java.io.File.pathSeparator+nativeValue);
            	added = true;
            } else if (win32){
                // Win32 variables are case-insensitive. If an exact match isn't found, iterate to
                // check for a case-insensitive match. We maintain the key's case (see bug 86725),
                // but do a case-insensitive comparison (for example, "pAtH" will still override "PATH").
                envIter = envcfgMap.entrySet().iterator();
                while (envIter.hasNext()) {
                    nativeEntry = (Map.Entry) envIter.next();
                    nativeKey = (String) (nativeEntry).getKey();
                    nativeValue = (String) (nativeEntry).getValue();
                    if (nativeKey.equalsIgnoreCase(key)) {
                        nativeEntry.setValue(value+java.io.File.pathSeparator+nativeValue);
                        added = true;
                        break;
                    }
                }
            }
            if (!added) {
            	envcfgMap.put(key, value);
            }
		}		
		return envcfgMap;
	}
}
