//  SVG Chart Generator JavaScript Functions 04/12/06
//
//
//**********************************************************************
// * Copyright (c) 2005 IBM Corporation and others.
// * All rights reserved.   This program and the accompanying materials
// * are made available under the terms of the Eclipse Public License v1.0
// * which accompanies this distribution, and is available at
// * http://www.eclipse.org/legal/epl-v10.html
// * $Id$
// * 
// * Contributors: 
// * IBM - Initial API and implementation
// **********************************************************************/

/////////////////////////////////////////////////////
// function: translateSVG
// description: translate the svg document by a specified x and y value
// inputs:
//   x - x value 
//   y - y value
////////////////////////////////////////////////////
function translateSVG(x, y){
  root=document.rootElement;
  root.currentTranslate.x =  root.currentTranslate.x + x;
  root.currentTranslate.y = root.currentTranslate.y + y;
}

//////////////////////////////////////////////////////////////////
// function: scaleSVG
// description: scales the svg document by a specified zoom factor
// inputs:
//   factor - zoom factor 
//////////////////////////////////////////////////////////////////
function scaleSVG(factor){
  root=document.rootElement;
  root.currentScale = factor
}

//////////////////////////////////////////////////////////////////////////
// function: restoreDefaultSVG
// description: restores SVG to it's original scale factor and position.
//////////////////////////////////////////////////////////////////////////
function restoreDefaultSVG(){
  root=document.rootElement;
  root.currentTranslate.x =  0;
  root.currentTranslate.y = 0;
  root.currentScale =  1;
}
