package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.ecore.EObject;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AssociatedEvent.java,v 1.2 2006/09/28 17:39:03 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object 
 * '<em><b>Associated Event</b></em>'. 
 * <P>
 * The AssociatedEvent type allows for associated events to be grouped.  
 * It allows for identifying associated events their association engines.  
 * The associationEngine <em>may</em> be the reference to the application that 
 * created the association. 
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getAssociationEngine <em>Association Engine</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getResolvedEvents <em>Resolved Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getAssociationEngineInfo <em>Association Engine Info</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociatedEvent()
 * @model 
 * @generated
 */
public interface AssociatedEvent extends EObject, Serializable {

    /**
     * Adds a Common Base Event reference to the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @param globalInstanceId The new Common Base Event globalInstanceId.
     * @see CommonBaseEvent
     * @since 1.0
     */
    void addResolvedEvent(String globalInstanceId);

    /**
     * Removes all Common Base Event references in the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @see CommonBaseEvent
     * @since 1.0
     */
    void clearResolvedEvents();

    /**
     * Removes a named Common Base Event reference in the array of resolved events.
     *     
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @param globalInstanceId The removed Common Base Event globalInstanceId.
     * @see CommonBaseEvent
     * @since 1.0
     */
    void removeResolvedEvent(String globalInstanceId);

    /**
     * <P>
     * Returns the value of the '<em><b>Association Engine</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Association Engine</em>' attribute.
     * @see #setAssociationEngine(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociatedEvent_AssociationEngine()
     * @model 
     * @generated
     */
    String getAssociationEngine();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getAssociationEngine <em>Association Engine</em>}' attribute.
     * <P>
     * <!-- begin-user-doc -->
     * <P>
     * Reference to the AssocationEngine that created this AssociatedEvent.
     * The associationEngine and associationEnginInfo properties are mutually 
     * exclusive.  One of these properties <em>must</em> be defined.
     * If this attribute is set, the '<em><b>Association Engine Info</b></em>'
     * attribute should not be set.
     * </P>
     * 
     * @throws IllegalStateException
     *                       if the '<em><b>Association Engine Info</b></em>'
     *                       attribute is currently set.
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Association Engine</em>' attribute.
     * @see #getAssociationEngine()
     * @generated
     */
    void setAssociationEngine(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Resolved Events</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <p>
     * The returned string follows the IDREFS type as stated in the CBE 
     * and defined in the XML Schema specification, which is a
     * space-separated list of IDREF strings.
     * </P>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Resolved Events</em>' attribute.
     * @see #setResolvedEvents(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociatedEvent_ResolvedEvents()
     * @model required="true"
     * @generated
     */
    String getResolvedEvents();

    /**
     * <P>
     * Returns the value of the '<em><b>Resolved Events</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <p>
     * The returned string follows the IDREFS type as stated in the CBE 
     * and defined in the XML Schema specification.  In this case it will
     * be an array of IDREF strings.  If there are no resolved events then
     * an empty array will be returned.
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Resolved Events</em>' attribute.
     * @see #setResolvedEvents(String)
     * @see #setResolvedEventsAsArray(String[])
     * @see #getResolvedEvents()
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociatedEvent_ResolvedEvents()
     * @model required="true"
     */
    String[] getResolvedEventsAsArray();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getResolvedEvents <em>Resolved Events</em>}' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * This is an array of globalInstanceIds 
     * corresponding to the events that are associated with this event.
     * </P>
     * <P>
     * This is a <em>required</em> property, an array with at least one element.
     * </P>
     * <P>
     * The parameter should follow the IDREFS type as stated in the CBE 
     * and defined in the XML Schema specification, which is a
     * space-separated list of IDREF strings.
     * </P>
     * 
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Resolved Events</em>' attribute.
     * @see #getResolvedEvents()
     * @see #validate()
     * @generated
     */
    void setResolvedEvents(String value);

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getResolvedEvents <em>Resolved Events</em>}' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * The parameter should follow the IDREFS type as stated in the CBE 
     * and defined in the XML Schema specification.  In this case it will
     * be an array of IDREF strings.
     * <P>
     * This method does not validate the parameter, which is left to separate
     * calls to the <code>validate</code> method.
     * </P>
     * 
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Resolved Events</em>' attribute.
     * @see #setResolvedEvents(String)
     * @see #getResolvedEvents()
     * @see #getResolvedEventsAsArray()
     * @see #validate()
     */
    void setResolvedEventsAsArray(String[] value);

    /**
     * <P>
     * Returns the value of the '<em><b>Association Engine Info</b></em>' containment reference.
     * </P>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Association Engine Info</em>' containment reference.
     * @see #setAssociationEngineInfo(AssociationEngine)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociatedEvent_AssociationEngineInfo()
     * @model containment="true"
     * @generated
     */
    AssociationEngine getAssociationEngineInfo();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getAssociationEngineInfo <em>Association Engine Info</em>}' containment reference.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * Identifies the application that establishes association among related 
     * or associated events.  In addition, it provides properties to describe 
     * the type of the association.
     * </P>
     * <P>
     * The associationEngine and associationEnginInfo properties are 
     * mutually exclusive.  One of these properties <em>must</em> be defined.
     * </P>
     * 
     * @throws IllegalStateException
     *                       if the '<em><b>Association Engine</b></em>'
     *                       attribute is currently set.
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Association Engine Info</em>' containment reference.
     * @see #getAssociationEngineInfo()
     * @generated
     */
    void setAssociationEngineInfo(AssociationEngine value);

    /**
     * <P>
     * Helper method for creating and setting the association engine 
     * information for this object.
     * </P>
     * <P>
     * It creates an <code>AssociationEngine</code> object and sets it in
     * the respective field of this object.
     * </P>
     * 
     * @param associationEngineName name for the association engine.
     * @param associationEngineType type for the association engine.
     * @param associationEngineId identifier for the association engine.
     */
    void setAssociationEngineInfo(String associationEngineName, String associationEngineType, String associationEngineId);

    /**
     * <P>
     * Checks whether the contents of this object conforms to the
     * CBE specification.
     * </P>
     * @throws ValidationException if the object does not follow the CBE specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // AssociatedEvent
