package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AvailableSituation.java,v 1.2 2006/09/28 17:39:03 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object
 * '<em><b>Available Situation</b></em>'.
 * <P>
 * The AvailableSituation deals with the situations reported from the 
 * component regarding its operational state and availability.  This 
 * situation provides a context for operations that can be performed 
 * on the component by distinguishing if a product is installed, operational, 
 * and ready to process functional requests.  Or, operational and ready/not 
 * ready to process management requests.  Existing messages include words 
 * like those that indicate it is ready to take requests, both online and offline.
 * For example:
 * </P>
 * <P>
 * <code>
 * ADMC0013I: SOAP connector available at port 8880
 * <br>
 * ADMC0026I: RMI Connector available at port 2809
 * </code>
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getOperationDisposition <em>Operation Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getAvailabilityDisposition <em>Availability Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getProcessingDisposition <em>Processing Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAvailableSituation()
 * @model 
 * @generated
 */
public interface AvailableSituation extends SituationType {
    /**
     * <P>
     * Returns the value of the '<em><b>Operation Disposition</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Operation Disposition</em>' attribute.
     * @see #setOperationDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAvailableSituation_OperationDisposition()
     * @model required="true"
     * @generated
     */
    String getOperationDisposition();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getOperationDisposition <em>Operation Disposition</em>}' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the operational state of the component reported 
     * by the situation.  The operationalDisposition is a string with the 
     * values such as:
     * <UL>
     * <LI>STARTABLE</LI>
     * <LI>NONSTARTABLE</LI>
     * </UL>
     * </P>
     * <P>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Operation Disposition</em>' attribute.
     * @see #getOperationDisposition()
     * @generated
     */
    void setOperationDisposition(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Availability Disposition</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Availability Disposition</em>' attribute.
     * @see #setAvailabilityDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAvailableSituation_AvailabilityDisposition()
     * @model required="true"
     * @generated
     */
    String getAvailabilityDisposition();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getAvailabilityDisposition <em>Availability Disposition</em>}' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the availability disposition of 
     * an entity or component that caused the situation to be reported. 
     * <P>
     * The availabilityDisposition is a string with the following set of values:
     * <UL>
     * <LI>AVAILABLE</LI>
     * <LI>NOT AVAILABLE</LI>
     * </UL>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Availability Disposition</em>' attribute.
     * @see #getAvailabilityDisposition()
     * @generated
     */
    void setAvailabilityDisposition(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Processing Disposition</b></em>' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Processing Disposition</em>' attribute.
     * @see #setProcessingDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAvailableSituation_ProcessingDisposition()
     * @model required="true"
     * @generated
     */
    String getProcessingDisposition();

    /**
     * <P>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getProcessingDisposition <em>Processing Disposition</em>}' attribute.
     * </P>
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the processing disposition of a component 
     * operation that caused the situation to be reported.
     * <P>
     * The processingDisposition is a string with the following set of values:
     * <UL>
     * <LI>FUNCTION_PROCESS</LI>
     * <LI>FUNCTION_BLOCK</LI>
     * <LI>MGMTTASK_PROCESS</LI>
     * <LI>MGMTTASK_BLOCKED</LI>
     * </UL>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Processing Disposition</em>' attribute.
     * @see #getProcessingDisposition()
     * @generated
     */
    void setProcessingDisposition(String value);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // AvailableSituation
