package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.core.ICommonBaseEvent;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonBaseEvent.java,v 1.1 2006/09/06 17:54:01 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Common Base Event</b></em>'.
 * <p>
 *
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0 
 * @extends ICommonBaseEvent
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setCreationTime <em>Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setGlobalInstanceId <em>Global Instance ID</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setElapsedTime <em>Elapsed Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setExtensionName <em>Extension Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setLocalInstanceId <em>Local Instance ID</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setMsg <em>Msg</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setPriority <em>Priority</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setRepeatCount <em>Repeat Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSequenceNumber <em>Sequence Number</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSeverity <em>Severity</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getAny <em>Any</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSituation <em>Situation</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getAssociatedEvents <em>Associated Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getContextDataElements <em>Context Data Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getExtendedDataElements <em>Extended Data Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setMsgDataElement <em>Msg Data Element</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setReporterComponentId <em>Reporter Component ID</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSourceComponentId <em>Source Component ID</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent()
 * @model 
 * @generated
 */
public interface CommonBaseEvent extends EObject, Serializable, ICommonBaseEvent {

    /**
     * <p>
     * Indicative of an event that does not need to be processed immediately.
     * </p>
     *
     * @see #setPriority(short)
     */
    short PRIORITY_LOW = 10;

    /**
     * <p>
     * Indicative of an event of average importance.
     * </p>
     *
     * @see #setPriority(short)
     */
    short PRIORITY_MEDIUM = 50;

    /**
     * <p>
     * Indicative of an important event that requires attention.
     * </p>
     *
     * @see #setPriority(short)
     */
    short PRIORITY_HIGH = 70;

    /**
     * <p>
     * Unknown is used for cases when the event severity is not known.
     * </p>
     *
     * @see #setSeverity(short)
     */
    short SEVERITY_UNKNOWN = 0;

    /**
     * <p>
     * Information is used for cases when the event only contains
     * general information and is not reporting an error.
     * </p>
     *
     * @see #setSeverity(short)
     */
    short SEVERITY_INFORMATION = 10;

    /**
     * <p>
     * Harmless is used for cases when the error event has no effect on
     * the normal operation of the resource.
     * </p>
     *
     * @see #setSeverity(short)
     */
    short SEVERITY_HARMLESS = 20;

    /**
     * <p>
     * Warning is used when it is appropriate to let the user decide if
     * an action is needed in response to the event.
     * </p>
     *
     * @see #setSeverity(short)
     */
    short SEVERITY_WARNING = 30;

    /**
     * <p>
     * Minor is used to indicate that action is needed, but the
     * situation is not serious at this time.
     * </p>
     *
     * @see #setSeverity(short)
     */
    short SEVERITY_MINOR = 40;

    /**
     * <p>
     * Critical is used to indicate that an immediate action is needed
     * and the scope is broad (perhaps an imminent outage to a critical
     * resource will result).
     * </p>
     *
     * @see #setSeverity(short)
     */
    short SEVERITY_CRITICAL = 50;

    /**
     * <p>
     * Fatal is used to indicate that an error occurred but it is too
     * late to take remedial action.
     * </p>
     *
     * @see #setSeverity(short)
     */
    short SEVERITY_FATAL = 60;

    /**
     * Returns the value of the '<em><b>Any</b></em>' attribute list.
     * The list contents are of type {@link java.lang.String}.
     * <!-- begin-user-doc -->
     * <P>
     * The XML fragment found inside an &lt;any&gt; element of the XML
     * representation of CBE event.
     * </P>
     * <P><b>Important</b>: This method is automatically generated and returns
     * an <code>EList</code>, which inherits from 
     * <code>{@link java.util.List}</code>
     * </P>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Any</em>' attribute list.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_Any()
     * @model type="java.lang.String" unique="false"
     * @generated
     */
    EList getAny();

    /**
     * Returns the value of the '<em><b>Associated Events</b></em>' containment reference list.
     * The list contents are of type {@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent}.
     * <!-- begin-user-doc -->
     * <P>
     * This property allows events to be grouped.  This property is a complex 
     * type that consists of globalInstanceIds that identify the associated 
     * events plus a type field that describes the type of association that 
     * is represented by the name of the association.
     * This is an <em>optional</em> property.
     * </P>
     * <P><b>Important</b>: This method is automatically generated and returns
     * an <code>EList</code>, which inherits from 
     * <code>{@link java.util.List}</code>
     * </P>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Associated Events</em>' containment reference list.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_AssociatedEvents()
     * @model type="org.eclipse.hyades.logging.events.cbe.AssociatedEvent" containment="true"
     * @generated
     */
    EList getAssociatedEvents();

    /**
     * Returns the value of the '<em><b>Context Data Elements</b></em>' containment reference list.
     * The list contents are of type {@link org.eclipse.hyades.logging.events.cbe.ContextDataElement}.
     * <!-- begin-user-doc -->
     * <P>
     * An array of contexts that this event is referencing.  See the 
     * ContextDataElement definition for details.
     * This is an <em>optional</em> property.
     * </P>
     * <P><b>Important</b>: This method is automatically generated and returns
     * an <code>EList</code>, which inherits from 
     * <code>{@link java.util.List}</code>
     * </P>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Context Data Elements</em>' containment reference list.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_ContextDataElements()
     * @model type="org.eclipse.hyades.logging.events.cbe.ContextDataElement" containment="true"
     * @generated
     */
    EList getContextDataElements();

    /**
     * Get a named a context that this event is referencing. See the
     * ContextDataElement definition (described on page 28) for details.
     * 
     * @param name the name of the element to be found
     * 
     * @return EList of ContextDataElements if the named element exists
     */
    EList getContextDataElements(String name);

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setCreationTime <em>Creation Time</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The date-time when the event was issued.  The value <em>must</em> be as defined 
     * by the XML Schema dateTime data type.  The value 
     * <em>must</em> be as precise as the generating platform allows. 
     * This is a <em>required</em> property.
     * </P>
     * <P>
     * The parameter is represented in terms of the DateTime XML type  as
     * defined in the XML Schema specification.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Creation Time</em>' attribute.
     * @see #isSetCreationTime()
     * @see #unsetCreationTime()
     * @see #getCreationTime()
     * @generated
     */
    void setCreationTime(String value);

    /**
     * <p>
     * Sets the value of the
     * '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setCreationTime <em>Creation Time</em>}'
     * attribute to <code>null</code> and turns off the <code>isSet</code> flag.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetCreationTime()
     * @see #getCreationTime()
     * @see #setCreationTime(String)
     * @generated
     */
    void unsetCreationTime();

    /**
     * <p>
     * Returns whether the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setCreationTime <em>Creation Time</em>}' attribute is set.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Creation Time</em>' attribute is set.
     * @see #unsetCreationTime()
     * @see #getCreationTime()
     * @see #setCreationTime(String)
     * @generated
     */
    boolean isSetCreationTime();

    /**
     * <p>
     * Returns the value of the '<em><b>Creation Time</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Creation Time</em>' attribute.
     * @see #isSetCreationTime()
     * @see #unsetCreationTime()
     * @see #setCreationTime(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_CreationTime()
     * @model unique="false" unsettable="true" required="true"
     * @generated
     */
    String getCreationTime();

    /**
     * Sets the XSD <code>dateTime</code> '<em><b>Creation Time</b></em>' attribute 
     * as a long (milliseconds) time stamp.
     * <p>
     * See {@link EventHelpers#dateToLong(String)} for more information 
     * on the long (milliseconds) and XSD <code>dateTime</code> time stamp
     * formats and the conversion from a long time stamp to an XSD 
     * <code>dateTime</code> time stamp.
     * <p>
     * 
     * @param creationTime The long (milliseconds) time stamp to be converted to the XSD <code>dateTime</code> '<em><b>Creation Time</b></em>' attribute.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_CreationTime()
     * @see EventHelpers#dateToLong(String)
     * @see #setCreationTime(String)
     * @see #getCreationTime()
     * @see #getCreationTimeAsLong()
     */    
    void setCreationTimeAsLong(long creationTime);

    /**
     * Resolves the XSD <code>dateTime</code> '<em><b>Creation Time</b></em>' attribute 
     * as a long (milliseconds) time stamp.
     * <p>
     * See {@link EventHelpers#dateToLong(String)} for more information 
     * on the XSD <code>dateTime</code> and long (milliseconds) time stamp
     * formats and the conversion from an XSD <code>dateTime</code> time 
     * stamp to a long time stamp.
     * <p>
     * 
     * @return The long (milliseconds) time stamp representation of the XSD <code>dateTime</code> '<em><b>Creation Time</b></em>' attribute.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_CreationTime()
     * @see EventHelpers#dateToLong(String)
     * @see #setCreationTime(String)
     * @see #getCreationTime()
     * @see #setCreationTimeAsLong(long)
     */
    long getCreationTimeAsLong();

    /**
     * <p>
     * Returns the value of the '<em><b>Elapsed Time</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * This is the time interval or the elapsed time for the number of occurrences
     * of a given event type that is specified by the repeatCount property. This
     * value indicates the duration of the time within which the repeated events 
     * were observed. This is an OPTIONAL property.  However, 
     * if repeatCount is specified you MUST specify a value for elapsedTime.
     * The default value is 0, which is a valid value for this property.
     * For this reason the '{@link org.eclipse.hyades.logging.events.cbe#isSetElapsedTime <em>isSetElapsedTime()</em>}' 
     * method should always be called before calling this method.  This allows the user to 
     * distinguish the default value from a value that has been set to 0.
     * <!-- end-user-doc -->
     * @return the value of the '<em>Elapsed Time</em>' attribute.
     * @see #isSetElapsedTime()
     * @see #unsetElapsedTime()
     * @see #setElapsedTime(long)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_ElapsedTime()
     * @model unique="false" unsettable="true"
     * @generated
     */
    long getElapsedTime();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setElapsedTime <em>Elapsed Time</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This is the time interval or the elapsed time during which the number 
     * of identical events occurred (as specified by the repeatCount property). 
     * This property is expressed in microseconds.  If no value (or zero) is 
     * specified for repeatCount, then this is an <em>optional</em> property.
     * However, if repeatCount is specified (it has a non-zero 
     * value), then elapsedTime is <em>required</em>.
     * The default value is 0, which is a valid value for this property.
     * Use the '{@link org.eclipse.hyades.logging.events.cbe#isSetElapsedTime <em>isSetElapsedTime()</em>}' 
     * to distinguish the default value from a value that has been set to 0. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Elapsed Time</em>' attribute.
     * @see #isSetElapsedTime()
     * @see #unsetElapsedTime()
     * @see #getElapsedTime()
     * @generated
     */
    void setElapsedTime(long value);

    /**
     * Sets the value of the 
     * '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setElapsedTime <em>Elapsed Time</em>}' 
     * attribute to <code>0</code> and turns off the <code>isSet</code> flag.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetElapsedTime()
     * @see #getElapsedTime()
     * @see #setElapsedTime(long)
     * @generated
     */
    void unsetElapsedTime();

    /**
     * <p>
     * Returns whether the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setElapsedTime <em>Elapsed Time</em>}' attribute is set.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Elapsed Time</em>' attribute is set.
     * @see #unsetElapsedTime()
     * @see #getElapsedTime()
     * @see #setElapsedTime(long)
     * @generated
     */
    boolean isSetElapsedTime();

    /**
     * <p>
     * Returns a named <code>ExtendedDataElement</code> from
     * the list of <code>ExtendedDataElement</code> objects.
     * </p>
     *
     * @param name           the name of the <code>ExtendedDataElement</code>
     *
     * @return               a list of <code>ExtendedDataElement</code> 
     *                        objects.
     * 
     * @see ExtendedDataElement
     */
    EList getExtendedDataElements(String name);

    /**
     * Returns the value of the '<em><b>Extended Data Elements</b></em>' containment reference list.
     * The list contents are of type {@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement}.
     * <!-- begin-user-doc -->
     * <P>
     * An array of product specific extensions that allows any other 
     * attributes not defined by the CommonBaseEvent.  Information placed 
     * here is assumed to be product specific data; its interpretation is 
     * not specified.
     * This is an <em>optional</em> property.
     * <P>
     * <P><b>Important</b>: This method is automatically generated and returns
     * an <code>EList</code>, which inherits from 
     * <code>{@link java.util.List}</code>
     * </P>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Extended Data Elements</em>' containment reference list.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_ExtendedDataElements()
     * @model type="org.eclipse.hyades.logging.events.cbe.ExtendedDataElement" containment="true"
     * @generated
     */
    EList getExtendedDataElements();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setExtensionName <em>Extension Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The name of an event class (or element in XML) that this event 
     * represents (for example, CommonBaseEvent). The name indicates any additional
     * elements that are expected to be present within the event.   
     * <P>
     * This is an <em>optional</em> property.  If the value specified is null, then 
     * the value is assumed to be <code>CommonBaseEvent</code>.  The string length for 
     * extensionName <em>must not</em> exceed 64 characters. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Extension Name</em>' attribute.
     * @see #getExtensionName()
     * @generated
     */
    void setExtensionName(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Extension Name</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Extension Name</em>' attribute.
     * @see #setExtensionName(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_ExtensionName()
     * @model 
     * @generated
     */
    String getExtensionName();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setGlobalInstanceId <em>Global Instance ID</em>}' attribute.
     * <!-- begin-user-doc -->
     * <p>
     * The primary identifier for the event.  This property <em>must</em> be globally 
     * unique and <em>may</em> be used as the primary key for the event. 
     * </p>
     * <p>
     * This is an <em>optional</em> property.  However, once this value is set it 
     * <em>must</em> never be changed.  The recommended value is either a 128 bit or 
     * 256 bit Globally Unique ID and <em>must</em> start with an alphabetic character 
     * (meaning, a-z and A-Z).
     * </p>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Global Instance ID</em>' attribute.
     * @see #getGlobalInstanceId()
     * @generated
     */
    void setGlobalInstanceId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Global Instance ID</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Global Instance ID</em>' attribute.
     * @see #setGlobalInstanceId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_GlobalInstanceId()
     * @model 
     * @generated
     */
    String getGlobalInstanceId();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setLocalInstanceId <em>Local Instance ID</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * A source supplied event identifier. There is no guarantee that this 
     * value is globally unique.
     * </P>
     * <P>
     * This is an <em>optional</em> property. The string length for localInstanceId 
     * <em>must not</em> exceed 128 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Local Instance ID</em>' attribute.
     * @see #getLocalInstanceId()
     * @generated
     */
    void setLocalInstanceId(String value);

    /**
     * </p>
     * Returns the value of the '<em><b>Local Instance ID</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Local Instance ID</em>' attribute.
     * @see #setLocalInstanceId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_LocalInstanceId()
     * @model 
     * @generated
     */
    String getLocalInstanceId();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setMsg <em>Msg</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The text accompanying the event. This is typically the resolved message 
     * string in human readable format rendered for a specific locale. 
     * </P>
     * <P>
     * This is and <em>optional</em> property.  The string length for msg <em>must not</em> 
     * exceed 1024 characters. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Msg</em>' attribute.
     * @see #getMsg()
     * @generated
     */
    void setMsg(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Msg</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg</em>' attribute.
     * @see #setMsg(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_Msg()
     * @model 
     * @generated
     */
    String getMsg();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setMsgDataElement <em>Msg Data Element</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <P>
     * Identification of the message that this event holds.  See the 
     * MsgDataElement definition.
     * This is an <em>optional</em> property.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Msg Data Element</em>' containment reference.
     * @see #getMsgDataElement()
     * @generated
     */
    void setMsgDataElement(MsgDataElement value);

    /**
     * <p>
     * Returns the value of the '<em><b>Msg Data Element</b></em>' containment reference.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg Data Element</em>' containment reference.
     * @see #setMsgDataElement(MsgDataElement)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_MsgDataElement()
     * @model containment="true"
     * @generated
     */
    MsgDataElement getMsgDataElement();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setPriority <em>Priority</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <P>
     * Defines the importance of the event. The predefined priorities are:
     * <UL>
     * <LI>10   Low</LI>
     * <LI>50  Medium</LI>
     * <LI>70   High</LI>
     * </UL>
     * The valid values are 0 to 100. The reserved value for Low is 10, for 
     * Medium is 50, and for High is 70.  Other priorities may be added but 
     * <em>must not</em> exceed 100.
     * This is an <em>optional</em> property.  
     * The default value is 0, which is a valid value for this property.
     * Use the '{@link org.eclipse.hyades.logging.events.cbe#isSetPriority <em>isSetPriority()</em>}' 
     * to distinguish the default value from a value that has been set to 0. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Priority</em>' attribute.
     * @see #isSetPriority()
     * @see #unsetPriority()
     * @see #getPriority()
     * @generated
     */
    void setPriority(short value);

    /**
     * <p>
     * Sets the value of the 
     * '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setPriority <em>Priority</em>}'
     * attribute to <code>0</code> and turns off the <code>isSet</code> flag.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetPriority()
     * @see #getPriority()
     * @see #setPriority(short)
     * @generated
     */
    void unsetPriority();

    /**
     * Returns whether the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setPriority <em>Priority</em>}' attribute is set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Priority</em>' attribute is set.
     * @see #unsetPriority()
     * @see #getPriority()
     * @see #setPriority(short)
     * @generated
     */
    boolean isSetPriority();

    /**
     * <p>
     * Returns the value of the '<em><b>Priority</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * The default value is 0, which is a valid value for this property.
     * For this reason the '{@link org.eclipse.hyades.logging.events.cbe#isSetPriority <em>isSetPriority()</em>}' 
     * method should always be called before calling this method.  This allows the user to 
     * distinguish the default value from a value that has been set to 0.
     * <!-- end-user-doc -->
     * @return the value of the '<em>Priority</em>' attribute.
     * @see #isSetPriority()
     * @see #unsetPriority()
     * @see #setPriority(short)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_Priority()
     * @model unsettable="true"
     * @generated
     */
    short getPriority();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setRepeatCount <em>Repeat Count</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The number of occurrences of an identical event within a specific time 
     * interval.
     * </P>
     * <P>
     * This is an <em>optional</em> property. A value of 0 or no value 
     * is indicative of no repeat of the event detected.
     * The default value is 0, which is a valid value for this property.
     * Use the '{@link org.eclipse.hyades.logging.events.cbe#isSetRepeatCount <em>isSetRepeatCount()</em>}' 
     * to distinguish the default value from a value that has been set to 0. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Repeat Count</em>' attribute.
     * @see #isSetRepeatCount()
     * @see #unsetRepeatCount()
     * @see #getRepeatCount()
     * @generated
     */
    void setRepeatCount(short value);

    /**
     * Sets the value of the 
     * '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setRepeatCount <em>Repeat Count</em>}'
     * attribute to <code>0</code> and turns off the <code>isSet</code> flag.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetRepeatCount()
     * @see #getRepeatCount()
     * @see #setRepeatCount(short)
     * @generated
     */
    void unsetRepeatCount();

    /**
     * <p>
     * Returns whether the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setRepeatCount <em>Repeat Count</em>}' attribute is set.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Repeat Count</em>' attribute is set.
     * @see #unsetRepeatCount()
     * @see #getRepeatCount()
     * @see #setRepeatCount(short)
     * @generated
     */
    boolean isSetRepeatCount();

    /**
     * <p>
     * Returns the value of the '<em><b>Repeat Count</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * The number of occurrences of a given event for a specific time interval.
     * This is an OPTIONAL property. A value of 0 or no value
     * is indicative of no repeat of the event detected.
     * The default value is 0, which is a valid value for this property.
     * For this reason the '{@link org.eclipse.hyades.logging.events.cbe#isSetRepeatCount <em>isSetRepeatCount()</em>}' 
     * method should always be called before calling this method.  This allows the user to 
     * distinguish the default value from a value that has been set to 0.
     * <!-- end-user-doc -->
     * @return the value of the '<em>Repeat Count</em>' attribute.
     * @see #isSetRepeatCount()
     * @see #unsetRepeatCount()
     * @see #setRepeatCount(short)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_RepeatCount()
     * @model unsettable="true"
     * @generated
     */
    short getRepeatCount();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setReporterComponentId <em>Reporter Component ID</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <P>
     * Identification of the component that is the reporter of the event or 
     * the situation. 
     * </P>
     * <P>
     * It is a <em>required</em> property if the reporting component is different than 
     * the source component.  Otherwise this field <em>must not</em> be present. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Reporter Component ID</em>' containment reference.
     * @see #getReporterComponentId()
     * @generated
     */
    void setReporterComponentId(ComponentIdentification value);

    /**
     * Sets the reporter component identifier for this event.
     * 
     * <P>
     * It creates a <code>ComponentIdentification</code> object and sets it in
     * the respective field of this object.
     * </p>
     *
     * @param application the name of the application for the source component
     * @param component the name of the component for the source component
     * @param subComponent the name of the subcomponent for the source
     *        component
     * @param componentType the component type for the source component
     * @param componentIdType the component ID type for the source component
     * @param location the location for the source component
     * @param locationType the location type for the source component
     */
    void setReporterComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String location, String locationType);

    /**
     * <p>
     * Helper method for creating and setting the reporter component ID for
     * this object.
     * </p>
     * <P>
     * It creates a <code>ComponentIdentification</code> object and sets it in
     * the respective field of this object.
     * </p>
     *
     * @param application the name of the application for the reporting
     *        component
     * @param component the name of the component for the reporting component
     * @param componentType the component type for the reporting component
     * @param componentIdType the component ID type for the reporting component
     * @param executionEnvironment the name of the execution environment for
     *        the reporting component
     * @param instanceId the instance ID for the reporting component
     * @param location the location for the reporting component
     * @param locationType the location type for the reporting component
     * @param processId the process ID for the reporting component
     * @param subComponent the name of the subcomponent for the reporting
     *        component
     * @param threadId the thread ID for the reporting component
     */
    void setReporterComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String executionEnvironment, String instanceId, String location, String locationType, String processId, String threadId);

    /**
     * <p>
     * Returns the value of the '<em><b>Reporter Component ID</b></em>' containment reference.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Reporter Component ID</em>' containment reference.
     * @see #setReporterComponentId(ComponentIdentification)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_ReporterComponentId()
     * @model containment="true"
     * @generated
     */
    ComponentIdentification getReporterComponentId();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSequenceNumber <em>Sequence Number</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * A source-defined number that allows for multiple messages to be sent 
     * and processed in a logical order that is different than the order in 
     * which they arrived at the consumer location (for example, an event server or 
     * management tools). The sequence number helps consumers to sort arrived 
     * messages that may arrive out-of-order. This is with respect to the 
     * creation time and to the particular reporter of the messages.
     * </P>
     * <P>
     * This is an <em>optional</em> property.
     * The default value is 0, which is a valid value for this property.
     * Use the '{@link org.eclipse.hyades.logging.events.cbe#isSetSequenceNumber <em>isSetSequenceNumber()</em>}' 
     * to distinguish the default value from a value that has been set to 0. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Sequence Number</em>' attribute.
     * @see #isSetSequenceNumber()
     * @see #unsetSequenceNumber()
     * @see #getSequenceNumber()
     * @generated
     */
    void setSequenceNumber(long value);

    /**
     * Sets the value of the 
     * '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSequenceNumber <em>Sequence Number</em>}'
     * attribute to <code>0</code> and turns off the <code>isSet</code> flag.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetSequenceNumber()
     * @see #getSequenceNumber()
     * @see #setSequenceNumber(long)
     * @generated
     */
    void unsetSequenceNumber();

    /**
     * <p>
     * Returns whether the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSequenceNumber <em>Sequence Number</em>}' attribute is set.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Sequence Number</em>' attribute is set.
     * @see #unsetSequenceNumber()
     * @see #getSequenceNumber()
     * @see #setSequenceNumber(long)
     * @generated
     */
    boolean isSetSequenceNumber();

    /**
     * <p>
     * Returns the value of the '<em><b>Sequence Number</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * A source defined number that allows for multiple messages to be sent
     * and processed in logical order different from the order in which they 
     * arrived at consumer location (e.g., an event server or management tools).
     * The sequence number helps consumers to sort arrived messages. This is 
     * with respect to the creation time and to the particular reporter of the 
     * messages. This is an OPTIONAL property.  
     * The default value is 0, which is a valid value for this property.
     * For this reason the '{@link org.eclipse.hyades.logging.events.cbe#isSequenceNumber <em>isSequenceNumber()</em>}' 
     * method should always be called before calling this method.  This allows the user to 
     * distinguish the default value from a value that has been set to 0.
     * <!-- end-user-doc -->
     * @return the value of the '<em>Sequence Number</em>' attribute.
     * @see #isSetSequenceNumber()
     * @see #unsetSequenceNumber()
     * @see #setSequenceNumber(long)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_SequenceNumber()
     * @model unsettable="true"
     * @generated
     */
    long getSequenceNumber();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSeverity <em>Severity</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The perceived severity of the status the event is describing with 
     * respect to the application that reports the event.  The predefined 
     * severity levels, in order of increasing severity, are as follows: 
     * <UL>
     * <LI>0 - Unknown</LI>
     * <LI>10 - Information <em>must</em> be used for cases when the event contains 
     * only general information and is not reporting an error.</LI>
     * <LI>20 - Harmless <em>must</em> be used for cases in which the error event 
     * has no effect on the normal operation of the resource.</LI>
     * <LI>30 - Warning <em>must</em> be used when it is appropriate to let the user 
     * decide if an action is needed in response to the event.</LI>
     * <LI>40   Minor <em>must</em> be used to indicate that action is needed, but 
     * the situation is not serious at this time.</LI>
     * <LI>50   Critical <em>must</em> be used to indicate that an immediate action 
     * is needed and the scope is broad (perhaps an imminent outage to a 
     * critical resource will result).</LI>
     * <LI>60   Fatal <em>must</em> be used to indicate that an error occurred, but it 
     * is too late to take remedial action.</LI>
     * </UL>
     * The associated values are 0 to 70. The reserved values start at 0 for 
     * Unknown and increase by increments of 10 to 60 for Fatal.  Other 
     * severities may be added but <em>must not</em> exceed 70.
     * This is an <em>optional</em> property.
     * The default value is 0, which is a valid value for this property.
     * Use the '{@link org.eclipse.hyades.logging.events.cbe#isSetSeverity <em>isSetSeverity()</em>}' 
     * to distinguish the default value from a value that has been set to 0. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Severity</em>' attribute.
     * @see #isSetSeverity()
     * @see #unsetSeverity()
     * @see #getSeverity()
     * @generated
     */
    void setSeverity(short value);

    /**
     * <p>
     * Sets the value of the 
     * '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSeverity <em>Severity</em>}'
     * attribute to <code>0</code> and turns off the <code>isSet</code> flag.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetSeverity()
     * @see #getSeverity()
     * @see #setSeverity(short)
     * @generated
     */
    void unsetSeverity();

    /**
     * <p>
     * Returns whether the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSeverity <em>Severity</em>}' attribute is set.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Severity</em>' attribute is set.
     * @see #unsetSeverity()
     * @see #getSeverity()
     * @see #setSeverity(short)
     * @generated
     */
    boolean isSetSeverity();

    /**
     * <p>
     * Returns the value of the '<em><b>Severity</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * The values are 0 to 70. The reserved values start at 0 for Unknown and increase
     * by increments of 10 to 60 for Fatal.  Other severities MAY be added but MUST not
     * exceed 70.  This is an OPTIONAL property.
     * The default value is 0, which is a valid value for this property.
     * For this reason the '{@link org.eclipse.hyades.logging.events.cbe#isSetSeverity <em>isSetSeverity()</em>}' 
     * method should always be called before calling this method.  This allows the user to 
     * distinguish the default value from a value that has been set to 0.
     * <!-- end-user-doc -->
     * @return the value of the '<em>Severity</em>' attribute.
     * @see #isSetSeverity()
     * @see #unsetSeverity()
     * @see #setSeverity(short)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_Severity()
     * @model unsettable="true"
     * @generated
     */
    short getSeverity();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSituation <em>Situation</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <P>
     * The situation specifies the type of the situation that caused the event 
     * to be reported. See the Situation definition for 
     * details.
     * This is a <em>required</em> property.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Situation</em>' containment reference.
     * @see #getSituation()
     * @generated
     */
    void setSituation(Situation value);

    /**
     * Returns the value of the '<em><b>Situation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Situation</em>' containment reference.
     * @see #setSituation(Situation)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_Situation()
     * @model containment="true" required="true"
     * @generated
     */
    Situation getSituation();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSourceComponentId <em>Source Component ID</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <P>
     * Identification of the component that is affected or was impacted by 
     * the event or the situation.  
     * </P>
     * <P>
     * This is a <em>required</em> property for the component that is affected by the 
     * situation. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Source Component ID</em>' containment reference.
     * @see #getSourceComponentId()
     * @generated
     */
    void setSourceComponentId(ComponentIdentification value);

    /**
     * Sets the source component identifier for this event.
     * 
     * <P>
     * It creates a <code>ComponentIdentification</code> object and sets it in
     * the respective field of this object.
     * </p>
     *
     * @param application the name of the application for the source component
     * @param component the name of the component for the source component
     * @param componentType the component type for the source component
     * @param componentIdType the component ID type for the source component
     * @param executionEnvironment the name of the execution environment for
     *        the source component
     * @param instanceId the instance ID for the source component
     * @param location the location for the source component
     * @param locationType the location type for the source component
     * @param processId the process ID for the source component
     * @param subComponent the name of the subcomponent for the source
     *        component
     * @param threadId the thread ID for the source component
     */
    void setSourceComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String executionEnvironment, String instanceId, String location, String locationType, String processId, String threadId);

    /**
     * Sets the source component identifier for this event.
     * 
     * <P>
     * It creates a <code>ComponentIdentification</code> object and sets it in
     * the respective field of this object.
     * </p>
     *
     * @param application the name of the application for the source component
     * @param component the name of the component for the source component
     * @param subComponent the name of the subcomponent for the source
     *        component
     * @param componentType the component type for the source component
     * @param componentIdType the component ID type for the source component
     * @param location the location for the source component
     * @param locationType the location type for the source component
     */
    void setSourceComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String location, String locationType);

    /**
     * <p>
     * Returns the value of the '<em><b>Source Component ID</b></em>' containment reference.
     * </p>
     * 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Source Component ID</em>' containment reference.
     * @see #setSourceComponentId(ComponentIdentification)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_SourceComponentId()
     * @model containment="true" required="true"
     * @generated
     */
    ComponentIdentification getSourceComponentId();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setVersion <em>Version</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * A string identifying the version of this event.
     * </P>
     * <P>
     * This field is <em>optional</em> in that if it isn't specified, the version of 
     * the CBE is said to be 1.0.  Otherwise this field <em>must</em> be filled in and 
     * <em>must</em> be consistent with the version specified in the schema header.
     * The string length for version <em>must not</em> exceed 16 characters. When an 
     * application is creating an event following this version of the 
     * specification this field should be set to <code>1.0.1</code>
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Version</em>' attribute.
     * @see #getVersion()
     * @generated
     */
    void setVersion(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Version</b></em>' attribute.
     * The default value is <code>"1.0.1"</code>.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Version</em>' attribute.
     * @see #setVersion(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent_Version()
     * @model default="1.0.1"
     * @generated
     */
    String getVersion();

    /**
     * Helper method for creating and setting an any element  for this object.
     * <P>
     * It creates an object and sets it in the respective field of this object.
     * </p>
     *
     * @param any A string representing an XML element.
     * 
     * @see #getAny()
     */
    void addAny(String any);

    /**
     * Helper method for creating and setting the associated events for
     * this object.
     * 
     * <P>
     * It creates an <code>AssociatedEvent</code> object and sets it in
     * the respective field of this object.
     * </p>
     *
     * @param associationEngineName name for the association engine
     * @param associationEngineType type for the association engine
     * @param associationEngineId identifier for the association engine.
     * @param resolvedEvents an array of globalInstanceIds that are associated
     *        to this event
     * 
     * @return               a reference to the associated events element added
     *                       to this object.
     * 
     * @see #getAssociatedEvents()
     */
    AssociatedEvent addAssociatedEvent(String associationEngineName, String associationEngineType, String associationEngineId, String[] resolvedEvents);

    /**
     * Adds a new context data element to this object.
     * 
     * <P>
     * It creates a <code>ContextDataElement</code> object and sets it in
     * the respective field of this object.
     * </p>
     *
     * @param contextType type of the context
     * @param contextName name of the context 
     * @param contextValue contextValue of the context
     * 
     * @return               a reference to the context data element added
     *                       to this object.
     * 
     * @see #getContextDataElements()
     */
    ContextDataElement addContextDataElementWithValue(String contextType, String contextName, String contextValue);

    /**
     * Adds a new context data element to this object.
     * 
     * <P>
     * It creates a <code>ContextDataElement</code> object and sets it in
     * the respective field of this object.
     * </p>
     *
     * @param contextType type of the context
     * @param contextName name of the context 
     * @param contextId contextId of the context
     * 
     * @return               a reference to the context data element added
     *                       to this object.
     * 
     * @see #getContextDataElements()
     */
    ContextDataElement addContextDataElementWithId(String contextType, String contextName, String contextId);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object without
     * any values adds it to the list of extended data elements for this 
     * object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElement(String name);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElement(String name, String value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>String</code> values for the 
     *                       new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElement(String name, String[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param type           represents the data type for the new
     *                       extended data element. Refer to the
     *                       <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code>
     *                       constants for valid types.
     * @param value          the value for the new extended data element.
     * 
     * @throws IllegalArgumentException
     *                       if the <code>type</code> parameter is not one
     *                       of the constants defined in
     *                       <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code> 
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElement(String name, int type, String value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param type           represents the data type for the new
     *                       extended data element. Refer to the
     *                       <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code>
     *                       constants for valid types.
     * @param values         the array of values for the new extended data 
     *                       element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @throws IllegalArgumentException
     *                       if the <code>type</code> parameter is not one
     *                       of the constants defined in
     *                       <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code> 
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElement(String name, int type, String[] values);

    /**
     * An array of product specific extensions for extensibility where you can
     * provide any other attributes not accounted for in the CommonBaseEventImpl.  
     * Information placed here is assumed to be product specific data.  This is
     * an OPTIONAL property.
     */
    ExtendedDataElement addExtendedDataElementWithBooleanArrayValue(String name, boolean[] values);

    /**
     * An array of product specific extensions for extensibility where you can
     * provide any other attributes not accounted for in the CommonBaseEventImpl.  
     * Information placed here is assumed to be product specific data.  This is
     * an OPTIONAL property.
     */
    ExtendedDataElement addExtendedDataElementWithBooleanValue(String name, boolean value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>byte</code> values for the new
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithByteArrayValue(String name, byte[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithByteValue(String name, byte value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     * <p>
     * The values correspond to a date time string according to the 
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>String</code> instances 
     *                       representing the date time values for the new 
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithDateArrayValue(String name, String[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          number of milliseconds since January 1, 1970 UTC;
     *                       representing the date time value for the new 
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithDateAsLongValue(String name, long value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     * <p>
     * The value corresponds to a date time string according to the 
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          representation of the date time value for the  new 
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithDateValue(String name, String value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>long</code> values for the new
     *                       extended data element.  Each value corresponds to 
     *                       the number of milliseconds since January 1, 1970 UTC.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithDatesAsLongValue(String name, long[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>double</code> values for the new
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithDoubleArrayValue(String name, double[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value the <code>double</code> value that the new
     *        <code>ExtendedDataElement</code> will contain.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithDoubleValue(String name, double value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>float/code> values for the new
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithFloatArrayValue(String name, float[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithFloatValue(String name, float value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>int</code> values for the new
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithIntArrayValue(String name, int[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithIntValue(String name, int value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>long</code> values for the new
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithLongArrayValue(String name, long[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithLongValue(String name, long value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing no  
     * value and adds it to the list of extended data elements for this 
     * object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithNoValue(String name);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>short</code> values for the new
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithShortArrayValue(String name, short[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the 
     * value passed as parameter and adds it to the list of extended data 
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithShortValue(String name, short value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the hexValue
     * passed as parameter and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param hexValue       the hexadecimal string for the 
     *                       <code>hexValue</code> field of the new
     *                       extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithHexValue(String name, String hexValue);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the hexValue
     * passed as parameter and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param hexValue       the array of bytes for the <code>hexValue</code> 
     *                       field of the new extended data element.
     * 
     * @return               a reference to the extended data element added
     *                       to this object.
     * 
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElementWithHexValue(String name, byte[] hexValue);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     *
     * @param extendedDataElement the new extended data element.
     * @return                    a reference to the extended data element added to this object.
     * @see #getExtendedDataElements()
     */
    ExtendedDataElement addExtendedDataElement(ExtendedDataElement extendedDataElement);

    /**
     * Removes all ExtenedDataElements that this event is referencing 
     */
    void clearExtendedDataElements();

    /**
     * Remove a named extended data element that this event is referencing 
     * 
     * @param name the name of the element to be removed
     */
    void removeExtendedDataElements(String name);

    /**
     * Adds a new <code>ContextDataElement</code> to this object.
     *
     * @param contextDataElement the new context data element.
     * @return                    a reference to the context data element added to this object.
     * @see #getContextDataElements()
     */
    ContextDataElement addContextDataElement(ContextDataElement contextDataElement);

    /**
     * Removes all ExtenedDataElements that this event is referencing 
     */
    void clearContextDataElements();

    /**
     * Remove a named context data element that this event is referencing 
     * 
     * @param name the name of the element to be removed
     */
    void removeContextDataElements(String name);

    /**
     * Adds a new <code>AssociatedEvent</code> to this object.
     *
     * @param associatedEvent the new context data element.
     * @return a reference to the context data element added to this object.
     * @see #getAssociatedEvents()
     */
    AssociatedEvent addAssociatedEvent(AssociatedEvent associatedEvent);

    /**
     * Removes all ExtenedDataElements that this event is referencing 
     */
    void clearAssociatedEvents();

    /**
     * Removes all any strings that this event is referencing 
     */
    void clearAny();

    /**
     * Adds a new <code>MsgDataElement</code> to this object.
     * 
     * <P>
     * It creates a <code>MsgDataElement</code> object and sets it in the
     * respective field of this object.
     * </p>
     *
     * @param msgCatalog the message catalog for this
     *        <code>MsgDataElement</code>
     * @param msgCatalogId the message catalog ID for this
     *        <code>MsgDataElement</code>
     * @param tokens the message catalog tokens for this
     *        <code>MsgDataElement</code>
     * @param msgCatalogType the message catalog type for this
     *        <code>MsgDataElement</code>
     * @param msgId the message ID for this <code>MsgDataElement</code>
     * @param msgIdType the message ID type for this
     *        <code>MsgDataElement</code>
     * @param msgCatalogLocale the locale for this <code>MsgDataElement</code>
     * 
     * @return               a reference to the message data element added
     *                       to this object.
     */
    MsgDataElement setMsgDataElement(String msgCatalog, String msgCatalogId, String[] tokens, String msgCatalogType, String msgId, String msgIdType, String msgCatalogLocale);

    /**
     * Adds a new <code>MsgDataElement</code> to this object.
     * 
     * <P>
     * It creates a <code>MsgDataElement</code> object and sets it in the
     * respective field of this object.
     * </p>
     *
     * @param msgCatalog the message catalog for this
     *        <code>MsgDataElement</code>
     * @param msgCatalogId the message catalog ID for this
     *        <code>MsgDataElement</code>
     * @param tokens the message catalog tokens for this
     *        <code>MsgDataElement</code>
     * @param msgCatalogType the message catalog type for this
     *        <code>MsgDataElement</code>
     * @param msgId the message ID for this <code>MsgDataElement</code>
     * @param msgIdType the message ID type for this
     *        <code>MsgDataElement</code>
     * @param msgCatalogLocale the locale for this <code>MsgDataElement</code>
     * 
     * @return               a reference to the message data element added
     *                       to this object.
     */
    MsgDataElement setMsgDataElement(String msgCatalog, String msgCatalogId, MsgCatalogToken[] tokens, String msgCatalogType, String msgId, String msgIdType, String msgCatalogLocale);

    /**
     * Invokes the content handler associated, if any, with this event instance.
     * <p>
     * Invocations of this method cause the flag denoting if <code>ContentHandler</code> 
     * associated with this event instance has been previously been invoked to be true.
     * <p>
     * 
     * @throws CompletionException
     *                       if the event content cannot be completed for
     *                       whatever reason. 
     */
    void complete() throws CompletionException;

    /**
     * Determines if the <code>ContentHandler</code> associated with this 
     * event instance, if any, has been previously been invoked.
     * <p>
     * 
     * @return True if the <code>ContentHandler</code> has been previously been invoked, otherwise false.
     */
    boolean isComplete();

    /**
     * Sets the <code>ContentHandler</code> associated with this 
     * event instance.
     * <p>
     * Invocations of this method cause the flag denoting if the <code>ContentHandler</code> 
     * associated with this event instance has been previously invoked to be <code>false</code>.
     * <p>
     *
     * @param contentHandler The new <code>ContentHandler</code> associated with this event instance.
     */
    void setContentHandler(ContentHandler contentHandler);

    /**
     * Gets the <code>ContentHandler</code> associated with this 
     * event instance.
     * <p>
     *
     * @return The <code>ContentHandler</code> associated with this event instance.
     */
    ContentHandler getContentHandler();

    /**
     * <p>
     * Checks whether the contents of the instance conform to the CBE
     * specification.
     * </p>
     *
     * @throws ValidationException 
     *                       if the event instance does not follow the
     *                       CBE specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state, except the <code>globalInstanceId</code> property.
     * <p>
     * This API assigns a new unique <code>GUID</code> to the <code>globalInstanceId</code> property.
     * <p>
     * 
     * @since 1.0
     */
    void init();
} // CommonBaseEvent
