package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConnectSituation.java,v 1.2 2006/09/28 17:39:03 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Connect Situation</b></em>'.
 * <P>
 * The ConnectSituation deals with the situations that identify aspects about 
 * a connection to another component.  Messages that say a connection failed, 
 * that a connection was created, or that a connection was ended all fall into 
 * this category.  Existing messages include words like connection reset, 
 * connection failed, and failed to get a connection, for example:
 * </P>
 * <P>
 * <code>
 * DBMN0015W: Failure while creating connection {0}
 * <br>
 * DBMN0033W: connection close failure {0}
 * <br>
 * DBMN0023W: Failed to close a connection {0}
 * </code>
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation#getSuccessDisposition <em>Success Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation#getSituationDisposition <em>Situation Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getConnectSituation()
 * @model 
 * @generated
 */
public interface ConnectSituation extends SituationType {
    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getConnectSituation_SuccessDisposition()
     * @model required="true"
     * @generated
     */
    String getSuccessDisposition();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation#getSuccessDisposition <em>Success Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies whether or not the operation that
     * caused the situation to be reported was successful.
     * The successDisposition is a string with the following set of values:
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </p>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Success Disposition</em>' attribute.
     * @see #getSuccessDisposition()
     * @generated
     */
    void setSuccessDisposition(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Situation Disposition</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Situation Disposition</em>' attribute.
     * @see #setSituationDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getConnectSituation_SituationDisposition()
     * @model required="true"
     * @generated
     */
    String getSituationDisposition();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation#getSituationDisposition <em>Situation Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the situation disposition that is a representation of the 
     * parameters necessary to describe the situation.
     * The situationDisposition is a string with the following set of values:
     * <UL>
     * <LI>INUSE</LI>
     * <LI>FREED</LI>
     * <LI>CLOSED</LI>
     * <LI>AVAILABLE</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </p>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Situation Disposition</em>' attribute.
     * @see #getSituationDisposition()
     * @generated
     */
    void setSituationDisposition(String value);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // ConnectSituation
