package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.ecore.EObject;

/**********************************************************************
* Copyright (c) 2005, 2006 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* $Id: ContextDataElement.java,v 1.2 2006/09/28 17:39:03 cjin Exp $
* 
* Contributors: 
* IBM - Initial API and implementation
**********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Context Data Element</b></em>'.
 * <P>
 * The ContextDataElement type defines the contexts that this event 
 * references.  This complex type holds data that is used to assist with 
 * problem diagnostics by correlating messages or events generated during 
 * execution of a unit of work. 
 * </P>
 * 
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getContextId <em>Context Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getContextValue <em>Context Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getContextDataElement()
 * @model 
 * @generated
 */
public interface ContextDataElement extends EObject, Serializable {
    /**
     * <p>
     * Returns the value of the '<em><b>Context Id</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Context Id</em>' attribute.
     * @see #setContextId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getContextDataElement_ContextId()
     * @model 
     * @generated
     */
    String getContextId();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getContextId <em>Context Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property is the reference to the globally unique identifier of the 
     * element that contains the context.
     * </P>
     * <P>
     * This is <em>required</em> unless contextValue specifies a value. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Context Id</em>' attribute.
     * @see #getContextId()
     * @generated
     */
    void setContextId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Context Value</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Context Value</em>' attribute.
     * @see #setContextValue(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getContextDataElement_ContextValue()
     * @model 
     * @generated
     */
    String getContextValue();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getContextValue <em>Context Value</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The value of the context with respect to the implementation of the 
     * context.
     * </P>
     * <P>
     * This is <em>required</em> unless contextId specifies a value. The string length 
     * for this property <em>must not</em> exceed 1024 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Context Value</em>' attribute.
     * @see #getContextValue()
     * @generated
     */
    void setContextValue(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Name</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Name</em>' attribute.
     * @see #setName(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getContextDataElement_Name()
     * @model required="true"
     * @generated
     */
    String getName();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getName <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * Name of the application that created this context data element.  
     * </P>
     * <P>
     * This is a <em>required</em> property. The string length for this property 
     * <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     * @generated
     */
    void setName(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Type</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Type</em>' attribute.
     * @see #setType(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getContextDataElement_Type()
     * @model required="true"
     * @generated
     */
    String getType();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getType <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The data type of the contextValue property. 
     * </P>
     * <P>
     * This is a <em>required</em> property. The string length for this property 
     * <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Type</em>' attribute.
     * @see #getType()
     * @generated
     */
    void setType(String value);

    /**
     * <p>
     * Checks whether the contents of this object conforms to the
     * CBE specification.
     * </p>
     *
     * @throws ValidationException 
     *                       if the object does not follow the 
     *                       CBE specification.
     */
    void validate() throws ValidationException;

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // ContextDataElement
