package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CreateSituation.java,v 1.2 2006/09/28 17:39:03 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Create Situation</b></em>'.
 * <P>
 * The CreateSituation deals with the situations documenting when a component 
 * creates an entity.  Messages telling that a document, file, or EJB 
 * was created all fall into this category. 
 * Existing message include words like "was created", "about to create", 
 * and "now exists", for example:
 * </P>
 * <P>
 * <code>
 * ADMR0009I: Document cells/flatfootNetwork/applications/Dynamic
 * <br> 
 * Cache Monitor.ear/Dynamic Cache Monitor.ear was created
 * </code>
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.CreateSituation#getSuccessDisposition <em>Success Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCreateSituation()
 * @model 
 * @generated
 */
public interface CreateSituation extends SituationType {
    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCreateSituation_SuccessDisposition()
     * @model required="true"
     * @generated
     */
    String getSuccessDisposition();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.CreateSituation#getSuccessDisposition <em>Success Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies whether or not the operation that
     * caused the situation to be reported was successful.
     * The successDisposition is a string with the following set of values:
     * 
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * 
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P> 
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Success Disposition</em>' attribute.
     * @see #getSuccessDisposition()
     * @generated
     */
    void setSuccessDisposition(String value);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // CreateSituation
