package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FormattingException.java,v 1.2 2008/01/24 02:52:27 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Typed exception representing a formatting error.
 * <p>
 * Exception thrown by the {@link org.eclipse.hyades.logging.events.cbe.util.EventFormatter} 
 * methods to indicate that a serialization or de-serialization error has occurred.
 * <p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version 1.0.1
 * @since   1.0.1
 * @see     org.eclipse.hyades.logging.events.cbe.util.EventFormatter
 */
public class FormattingException extends EventException {

    /**
     * Stream-Unique IDentifier (SUID) of this class.
     * <p>
     * NOTE:  This value MUST not be modified unless an incompatible 
     *        change is introduced.  
     * <p>
     * See the 'Java Object Serialization Specification' for more details.
     * <p>
     * Compatible changes include:
     * <ul>
     * <li>Adding, modifying access or modifying <code>static</code>/<code>transient</code> to non-<code>static</code>/non-<code>transient</code> of fields.</li>
     * <li>Adding or removing classes.</li>
     * <li>Adding or removing <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>java.io.Serializable</code> inheritance.</li>
     * </ul>
     * <p>
     * Incompatible changes include:
     * <ul>
     * <li>Deleting, modifying non-<code>static</code>/non-<code>transient</code> to <code>static</code>/<code>transient</code> or modifying the declared type of fields.</li>
     * <li>Modifying the hierarchy or interchanging/removing <code>java.io.Serializable</code>/<code>java.io.Externalizable</code> inheritance of the class.</li>
     * <li>Modifying <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>writeReplace</code>/<code>readResolve</code> methods.</li>
     * </ul>
     */
    protected static final long serialVersionUID = 2030987872919272556L;

    /**
     * No-arguement constructor.
     * <p>
     */
    public FormattingException() {
        super();
    }

    /**
     * Constructs a <code>FormattingException</code> with the specified detail
     * message.
     *
     * @param message            the detail message
     */
    public FormattingException(String message) {
        super(message);
    }

    /**
     * Constructs a <code>FormattingException</code> with the specified detail
     * message and a nested exception.
     *
     * @param message            the detail message
     * @param cause The nested exception, or <code>null</code>, if a nested
     *        exception is not appropriate.
     */
    public FormattingException(String message, Throwable cause) {
        super(message,cause);
    }
    /**
     * Creates a <code>FormattingException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions).
     *
     * @param key The message key.
     * @param resourceBundleName The name of the message ResourceBundle to use.
     */
    public FormattingException(String key, String resourceBundleName) {
        super(key, resourceBundleName, null);
    }

    /**
     * Creates a <code>FormattingException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions).
     *
     * @param key The message key.
     * @param resourceBundleName The name of the message ResourceBundle to use.
     * @param parameters An array of elements to be inserted into the message.
     */
    public FormattingException(String key, String resourceBundleName, Object[] parameters) {
        super(key, resourceBundleName, parameters);
    }

    /**
     * Creates a <code>FormattingException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions) and a nested exception.
     *
     * @param key The message key.
     * @param resourceBundleName The name of the message ResourceBundle to use.
     * @param parameters An array of elements to be inserted into the message.
     * @param cause The nested exception, or <code>null</code>, if a nested
     *        exception is not appropriate.
     */
    public FormattingException(String key, String resourceBundleName, Object[] parameters, Throwable cause) {
        super(key, resourceBundleName, parameters, cause);
    }

    /**
     * Construct a new <code>FormattingException</code> with
     * a null detail message and a cause field set to the specified
     * Throwable. Subsequent calls to the {@link #initCause} method
     * on this instance will result in an exception. The value of
     * the cause field may be retrieved at any time via the {@link
     * #getCause()} method.
     *
     * @param cause the Throwable that was caught and is considered
     *        the root cause of this exception. Null is tolerated.
     */
    public FormattingException(Exception cause) {
        super(cause);
    }
}
