package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportSituation.java,v 1.2 2006/09/28 17:39:03 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Report Situation</b></em>'.
 * <P>
 * The ReportSituation deals with the situations reported from the component, 
 * such as heartbeat or performance information.  Data such as current CPU 
 * utilization, current memory heap size, etc. would fall into this category.
 * Existing messages include words like "utilization value is", "buffer size is", 
 * and "number of threads is", for example:
 * </P>
 * <P>
 * <code>
 * IEE890I WTO Buffers in console backup storage = 1024
 * </code>
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ReportSituation#getReportCategory <em>Report Category</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getReportSituation()
 * @model 
 * @generated
 */
public interface ReportSituation extends SituationType {
    /**
     * <p>
     * Returns the value of the '<em><b>Report Category</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Report Category</em>' attribute.
     * @see #setReportCategory(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getReportSituation_ReportCategory()
     * @model required="true"
     * @generated
     */
    String getReportCategory();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ReportSituation#getReportCategory <em>Report Category</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the category of the reported situation. 
     * The reportCategory is a string with the following set of values:
     * <UL>
     * <LI>PERFORMANCE</LI>
     * <LI>SECURITY</LI>
     * <LI>HEARTBEAT</LI>
     * <LI>STATUS</LI>
     * </UL>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Report Category</em>' attribute.
     * @see #getReportCategory()
     * @generated
     */
    void setReportCategory(String value);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // ReportSituation
