package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.ecore.EObject;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SituationType.java,v 1.2 2006/09/28 17:39:03 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Situation Type</b></em>'.
 * <P>
 * The situationType specifies the type or category of the situation that 
 * caused the event to be reported.  The categorization of situations 
 * facilitates the building of tools that focus on implementing the 
 * analysis and planning functions rather than on product-specific 
 * data formats.  The data type for this property is a complex type.  The 
 * situation types or categories are defined below.  SituationType is an 
 * abstract element that is used to define all supported situation types 
 * (for example, StartSituation, StopSituation, etc...).
 * </P>
 * <P> 
 * The simplest way to understand the usefulness of categorization is by 
 * providing a use case.  For example, assume that a problem has been 
 * detected with component 'A'.  The first step in the root cause analysis 
 * might be to check to see if 'x' was actually started, since it is known 
 * that 'A' has a dependency on 'x'.  One approach to determine if 'x' is 
 * running is to check the log file for 'x' to see if it has started.  The 
 * problem from a programmatic perspective is that there is not standard way 
 * to check the log files to see if 'x' has started.  'x' might log "Component 
 * 'x' started" or it might log "Change server state from starting to running". 
 * The reality is that both of these messages provide the same information, but 
 * they provide it using different terminology, making it difficult for a 
 * program to use.  Simple checks like this would be much easier if all 
 * components reported, for example, that they "started".  Writing code to check 
 * dependencies would be much easier and would be, largely, component 
 * independent.  For example, if product 'A' had dependencies on 'x' and 'y', 
 * the code to check the status of 'x' and the code to check the status of 'y' 
 * would be the same, in both cases, it would look for a 'started' message.
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.SituationType#getReasoningScope <em>Reasoning Scope</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getSituationType()
 * @model abstract="true"
 * @generated
 */
public interface SituationType extends EObject, Serializable {
    /**
     * <p>
     * Returns the value of the '<em><b>Reasoning Scope</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Reasoning Scope</em>' attribute.
     * @see #setReasoningScope(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getSituationType_ReasoningScope()
     * @model required="true"
     * @generated
     */
    String getReasoningScope();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.SituationType#getReasoningScope <em>Reasoning Scope</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the scope of the impact of the situation 
     * reported.
     * The initial set of values is described following this table.
     * This is a <em>required</em> property. The string length for this property 
     * <em>must not</em> exceed 64 characters.
     * <P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Reasoning Scope</em>' attribute.
     * @see #getReasoningScope()
     * @generated
     */
    void setReasoningScope(String value);

    /**
     * <p>
     * Checks whether the contents of the instance conform to the
     * CBE specification.
     * </p>
     *
     * @throws ValidationException 
     *                       if the situation type does not follow the 
     *                       CBE specification.
     */
    void validate() throws ValidationException;

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // SituationType
