package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TemplateContentHandler.java,v 1.2 2006/09/28 17:39:03 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Extension of the <code>ContentHandler</code> interface for specifying 
 * a template event.
 * <p>
 * The template event is used to store event configuration properties that
 * are merged into the parameter event in the implementation of the 
 * <code>completeEvent(CommonBaseEvent event)</code> API.
 * <p>
 * Implementations MUST preserve the precedence rules for merging event properties when 
 * implementing the <code>completeEvent(CommonBaseEvent event)</code> API.  The precedence 
 * rules for merging event properties are as follows:
 * <p>
 * 1) The 'template event' contains the event properties to be merged into the 'base event'.
 * 2) String and primitive property values in the 'base event' are considered 'golden' when 
 *    the same property is set in the 'template event'.
 * 3) List property values in the 'template event' are concatenated to the associated list property
 *    in the 'base event'.
 * 4) Complex (e.g. objects excluding strings) property values in the 'base event' are internally 
 *    compared to the associated 'template event' property using the above rules.
 * <p>
 * For security reasons, once a non-null template event has been set on 
 * <code>TemplateContentHandler</code> instance, no other template event 
 * can be set for the life cycle of the <code>TemplateContentHandler</code> 
 * instance. 
 * <p>
 *
 * @author Paul E Slauenwhite
 * @version 1.0.1
 * @since 1.0.1 
 * @see org.eclipse.hyades.logging.events.cbe.ContentHandler
 */
public interface TemplateContentHandler extends ContentHandler {

    /**
     * Sets a new template event on this content handler instance.
     * <p>
     * The template event is used to store event configuration properties that
     * are merged into the parameter event in the implementation of the 
     * <code>completeEvent(CommonBaseEvent event)</code> API.
     * <p>
     * For security reasons, once a non-null template event has been set on 
     * <code>TemplateContentHandler</code> instance, no other template event 
     * can be set for the life cycle of the <code>TemplateContentHandler</code> 
     * instance. 
     * <p>
     * 
     * @param templateEvent The new template event associated with this content handler instance.
     */
    void setTemplateEvent(CommonBaseEvent templateEvent);
}
