package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AvailableSituationImpl.java,v 1.1 2006/09/06 17:54:06 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Available Situation</b></em>'.
 * 
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1 
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.AvailableSituationImpl#getOperationDisposition <em>Operation Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.AvailableSituationImpl#getAvailabilityDisposition <em>Availability Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.AvailableSituationImpl#getProcessingDisposition <em>Processing Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AvailableSituationImpl extends SituationTypeImpl implements AvailableSituation, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 8909448887998100984L;

    /**
     * The default value of the '{@link #getOperationDisposition() <em>Operation Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOperationDisposition()
     * @generated
     * @ordered
     */
    protected static final String OPERATION_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getOperationDisposition() <em>Operation Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOperationDisposition()
     * @generated
     * @ordered
     */
    protected String operationDisposition = OPERATION_DISPOSITION_EDEFAULT;

    /**
     * The default value of the '{@link #getAvailabilityDisposition() <em>Availability Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAvailabilityDisposition()
     * @generated
     * @ordered
     */
    protected static final String AVAILABILITY_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getAvailabilityDisposition() <em>Availability Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAvailabilityDisposition()
     * @generated
     * @ordered
     */
    protected String availabilityDisposition = AVAILABILITY_DISPOSITION_EDEFAULT;

    /**
     * The default value of the '{@link #getProcessingDisposition() <em>Processing Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getProcessingDisposition()
     * @generated
     * @ordered
     */
    protected static final String PROCESSING_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getProcessingDisposition() <em>Processing Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getProcessingDisposition()
     * @generated
     * @ordered
     */
    protected String processingDisposition = PROCESSING_DISPOSITION_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AvailableSituationImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getAvailableSituation();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getOperationDisposition() {
        return operationDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setOperationDisposition(String newOperationDisposition) {
        String oldOperationDisposition = operationDisposition;
        operationDisposition = newOperationDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.AVAILABLE_SITUATION__OPERATION_DISPOSITION, oldOperationDisposition, operationDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getAvailabilityDisposition() {
        return availabilityDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setAvailabilityDisposition(String newAvailabilityDisposition) {
        String oldAvailabilityDisposition = availabilityDisposition;
        availabilityDisposition = newAvailabilityDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION, oldAvailabilityDisposition, availabilityDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getProcessingDisposition() {
        return processingDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setProcessingDisposition(String newProcessingDisposition) {
        String oldProcessingDisposition = processingDisposition;
        processingDisposition = newProcessingDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.AVAILABLE_SITUATION__PROCESSING_DISPOSITION, oldProcessingDisposition, processingDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.AVAILABLE_SITUATION__REASONING_SCOPE :
                return getReasoningScope();
            case EventPackage.AVAILABLE_SITUATION__OPERATION_DISPOSITION :
                return getOperationDisposition();
            case EventPackage.AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION :
                return getAvailabilityDisposition();
            case EventPackage.AVAILABLE_SITUATION__PROCESSING_DISPOSITION :
                return getProcessingDisposition();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.AVAILABLE_SITUATION__REASONING_SCOPE :
                setReasoningScope((String) newValue);
                return;
            case EventPackage.AVAILABLE_SITUATION__OPERATION_DISPOSITION :
                setOperationDisposition((String) newValue);
                return;
            case EventPackage.AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION :
                setAvailabilityDisposition((String) newValue);
                return;
            case EventPackage.AVAILABLE_SITUATION__PROCESSING_DISPOSITION :
                setProcessingDisposition((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.AVAILABLE_SITUATION__REASONING_SCOPE :
                setReasoningScope(REASONING_SCOPE_EDEFAULT);
                return;
            case EventPackage.AVAILABLE_SITUATION__OPERATION_DISPOSITION :
                setOperationDisposition(OPERATION_DISPOSITION_EDEFAULT);
                return;
            case EventPackage.AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION :
                setAvailabilityDisposition(AVAILABILITY_DISPOSITION_EDEFAULT);
                return;
            case EventPackage.AVAILABLE_SITUATION__PROCESSING_DISPOSITION :
                setProcessingDisposition(PROCESSING_DISPOSITION_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.AVAILABLE_SITUATION__REASONING_SCOPE :
                return REASONING_SCOPE_EDEFAULT == null ? reasoningScope != null : !REASONING_SCOPE_EDEFAULT.equals(reasoningScope);
            case EventPackage.AVAILABLE_SITUATION__OPERATION_DISPOSITION :
                return OPERATION_DISPOSITION_EDEFAULT == null ? operationDisposition != null : !OPERATION_DISPOSITION_EDEFAULT.equals(operationDisposition);
            case EventPackage.AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION :
                return AVAILABILITY_DISPOSITION_EDEFAULT == null ? availabilityDisposition != null : !AVAILABILITY_DISPOSITION_EDEFAULT.equals(availabilityDisposition);
            case EventPackage.AVAILABLE_SITUATION__PROCESSING_DISPOSITION :
                return PROCESSING_DISPOSITION_EDEFAULT == null ? processingDisposition != null : !PROCESSING_DISPOSITION_EDEFAULT.equals(processingDisposition);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (operationDisposition: ");
        result.append(operationDisposition);
        result.append(", availabilityDisposition: ");
        result.append(availabilityDisposition);
        result.append(", processingDisposition: ");
        result.append(processingDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){

            super.validate();

            //Step 1:  Check for required properties:
            if(operationDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.AvailableSituation.OperationDisposition")); 
            }

            if(availabilityDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.AvailableSituation.AvailabilityDisposition")); 
            }

            if(processingDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.AvailableSituation.ProcessingDisposition")); 
            }

            //Step 2:  Check content of each property:
            if(operationDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.AvailableSituation.OperationDisposition", operationDisposition, new Integer(operationDisposition.length()), new Integer(64)));
            }

            if(availabilityDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.AvailableSituation.AvailabilityDisposition", availabilityDisposition, new Integer(availabilityDisposition.length()), new Integer(64)));
            }

            if(processingDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.AvailableSituation.ProcessingDisposition", processingDisposition, new Integer(processingDisposition.length()), new Integer(64)));
            }
        }
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized(this){
            return EventHelpers.compareEObject(this, object);
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setAvailabilityDisposition(AVAILABILITY_DISPOSITION_EDEFAULT);
        setOperationDisposition(OPERATION_DISPOSITION_EDEFAULT);
        setProcessingDisposition(PROCESSING_DISPOSITION_EDEFAULT);
    }
} //AvailableSituationImpl
