package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConnectSituationImpl.java,v 1.1 2006/09/06 17:54:06 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Connect Situation</b></em>'.
 * 
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1 
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ConnectSituationImpl#getSuccessDisposition <em>Success Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ConnectSituationImpl#getSituationDisposition <em>Situation Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConnectSituationImpl extends SituationTypeImpl implements ConnectSituation, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 2872460422753085360L;

    /**
     * The default value of the '{@link #getSuccessDisposition() <em>Success Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSuccessDisposition()
     * @generated
     * @ordered
     */
    protected static final String SUCCESS_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSuccessDisposition() <em>Success Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSuccessDisposition()
     * @generated
     * @ordered
     */
    protected String successDisposition = SUCCESS_DISPOSITION_EDEFAULT;

    /**
     * The default value of the '{@link #getSituationDisposition() <em>Situation Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSituationDisposition()
     * @generated
     * @ordered
     */
    protected static final String SITUATION_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSituationDisposition() <em>Situation Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSituationDisposition()
     * @generated
     * @ordered
     */
    protected String situationDisposition = SITUATION_DISPOSITION_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConnectSituationImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getConnectSituation();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getSuccessDisposition() {
        return successDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSuccessDisposition(String newSuccessDisposition) {
        String oldSuccessDisposition = successDisposition;
        successDisposition = newSuccessDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.CONNECT_SITUATION__SUCCESS_DISPOSITION, oldSuccessDisposition, successDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getSituationDisposition() {
        return situationDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSituationDisposition(String newSituationDisposition) {
        String oldSituationDisposition = situationDisposition;
        situationDisposition = newSituationDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.CONNECT_SITUATION__SITUATION_DISPOSITION, oldSituationDisposition, situationDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.CONNECT_SITUATION__REASONING_SCOPE :
                return getReasoningScope();
            case EventPackage.CONNECT_SITUATION__SUCCESS_DISPOSITION :
                return getSuccessDisposition();
            case EventPackage.CONNECT_SITUATION__SITUATION_DISPOSITION :
                return getSituationDisposition();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.CONNECT_SITUATION__REASONING_SCOPE :
                setReasoningScope((String) newValue);
                return;
            case EventPackage.CONNECT_SITUATION__SUCCESS_DISPOSITION :
                setSuccessDisposition((String) newValue);
                return;
            case EventPackage.CONNECT_SITUATION__SITUATION_DISPOSITION :
                setSituationDisposition((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.CONNECT_SITUATION__REASONING_SCOPE :
                setReasoningScope(REASONING_SCOPE_EDEFAULT);
                return;
            case EventPackage.CONNECT_SITUATION__SUCCESS_DISPOSITION :
                setSuccessDisposition(SUCCESS_DISPOSITION_EDEFAULT);
                return;
            case EventPackage.CONNECT_SITUATION__SITUATION_DISPOSITION :
                setSituationDisposition(SITUATION_DISPOSITION_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.CONNECT_SITUATION__REASONING_SCOPE :
                return REASONING_SCOPE_EDEFAULT == null ? reasoningScope != null : !REASONING_SCOPE_EDEFAULT.equals(reasoningScope);
            case EventPackage.CONNECT_SITUATION__SUCCESS_DISPOSITION :
                return SUCCESS_DISPOSITION_EDEFAULT == null ? successDisposition != null : !SUCCESS_DISPOSITION_EDEFAULT.equals(successDisposition);
            case EventPackage.CONNECT_SITUATION__SITUATION_DISPOSITION :
                return SITUATION_DISPOSITION_EDEFAULT == null ? situationDisposition != null : !SITUATION_DISPOSITION_EDEFAULT.equals(situationDisposition);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (successDisposition: ");
        result.append(successDisposition);
        result.append(", situationDisposition: ");
        result.append(situationDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){

            super.validate();

            //Step 1:  Check for required properties:
            if(successDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.ConnectSituation.SuccessDisposition")); 
            }

            if(situationDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.ConnectSituation.SituationDisposition")); 
            }

            //Step 2:  Check content of each property:
            if(successDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.ConnectSituation.SuccessDisposition", successDisposition, new Integer(successDisposition.length()), new Integer(64)));
            }

            if(situationDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.ConnectSituation.SituationDisposition", situationDisposition, new Integer(situationDisposition.length()), new Integer(64)));
            }
        }
    }

	/**
	 * return a cloned (copy by value) object. This is a deep copy version, in which all the
	 * objects within this object will be copied by value.
	 *  
	 * @return Object
	 */
	public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
	}

	/**
	 * Overrides the <code>java.lang.Object</code>'s equals() API to 
	 * determine if the parameter <code>object</code> is equal to this object.
	 * 
	 * @param object The <code>java.lang.Object</code> to be compared to this object.
	 * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {

        synchronized(this){
            return EventHelpers.compareEObject(this, object);
        }
	}

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setSituationDisposition(SITUATION_DISPOSITION_EDEFAULT);
        setSuccessDisposition(SUCCESS_DISPOSITION_EDEFAULT);
    }
} //ConnectSituationImpl
