package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DependencySituationImpl.java,v 1.1 2006/09/06 17:54:06 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Dependency Situation</b></em>'.
 * 
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.DependencySituationImpl#getDependencyDisposition <em>Dependency Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DependencySituationImpl extends SituationTypeImpl implements DependencySituation, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -5050575227459575744L;

    /**
     * The default value of the '{@link #getDependencyDisposition() <em>Dependency Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDependencyDisposition()
     * @generated
     * @ordered
     */
    protected static final String DEPENDENCY_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDependencyDisposition() <em>Dependency Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDependencyDisposition()
     * @generated
     * @ordered
     */
    protected String dependencyDisposition = DEPENDENCY_DISPOSITION_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DependencySituationImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getDependencySituation();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getDependencyDisposition() {
        return dependencyDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDependencyDisposition(String newDependencyDisposition) {
        String oldDependencyDisposition = dependencyDisposition;
        dependencyDisposition = newDependencyDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION, oldDependencyDisposition, dependencyDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DEPENDENCY_SITUATION__REASONING_SCOPE :
                return getReasoningScope();
            case EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION :
                return getDependencyDisposition();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DEPENDENCY_SITUATION__REASONING_SCOPE :
                setReasoningScope((String) newValue);
                return;
            case EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION :
                setDependencyDisposition((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DEPENDENCY_SITUATION__REASONING_SCOPE :
                setReasoningScope(REASONING_SCOPE_EDEFAULT);
                return;
            case EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION :
                setDependencyDisposition(DEPENDENCY_DISPOSITION_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DEPENDENCY_SITUATION__REASONING_SCOPE :
                return REASONING_SCOPE_EDEFAULT == null ? reasoningScope != null : !REASONING_SCOPE_EDEFAULT.equals(reasoningScope);
            case EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION :
                return DEPENDENCY_DISPOSITION_EDEFAULT == null ? dependencyDisposition != null : !DEPENDENCY_DISPOSITION_EDEFAULT.equals(dependencyDisposition);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dependencyDisposition: ");
        result.append(dependencyDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){

            super.validate();

            //Step 1:  Check for required properties:
            if(dependencyDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.DependencySituation.DependencyDisposition")); 
            }

            //Step 2:  Check content of each property:
            if(dependencyDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.DependencySituation.DependencyDisposition", dependencyDisposition, new Integer(dependencyDisposition.length()), new Integer(64)));
            }
        }
    }

	/**
	 * return a cloned (copy by value) object. This is a deep copy version, in which all the
	 * objects within this object will be copied by value.
	 *  
	 * @return Object
	 */
	public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
	}

	/**
	 * Overrides the <code>java.lang.Object</code>'s equals() API to 
	 * determine if the parameter <code>object</code> is equal to this object.
	 * 
	 * @param object The <code>java.lang.Object</code> to be compared to this object.
	 * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {

        synchronized(this){
            return EventHelpers.compareEObject(this, object);
        }
	}

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setDependencyDisposition(DEPENDENCY_DISPOSITION_EDEFAULT);
    }
} //DependencySituationImpl
