package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;

import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventFactoryObjectFactory.java,v 1.1 2006/09/06 17:54:06 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JNDI object factory for <code>EventFactory</code> objects.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * 
 * @see org.eclipse.hyades.logging.events.cbe.EventFactory
 */
public class EventFactoryObjectFactory implements ObjectFactory {

    /*
     * Public methods
     */

    /**
     * Simple constructor.
     */
    public EventFactoryObjectFactory() {
    }

    /**
     * @see javax.naming.spi.ObjectFactory#getObjectInstance(Object, Name, Context, Hashtable)
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {

        EventFactoryImpl result = null;

        if (obj instanceof Reference) {
            Reference ref = (Reference) obj;
            RefAddr refAddr = ref.get(EventFactoryImpl.CBE_INSTANCE_ADDRESS);
            if (refAddr instanceof BinaryRefAddr) {
                BinaryRefAddr binAddr = (BinaryRefAddr) refAddr;
                byte[] content = (byte[]) binAddr.getContent();
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(content);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    ContentHandler mh = null;
                    try {
                        mh = (ContentHandler) ois.readObject();
                    }
                    finally {
                        ois.close();
                        bis.close();
                    }
                    result = new EventFactoryImpl();
                    result.setContentHandler(mh);
                }
                catch (IOException e) {
                    throw new EventException(LoggingCoreResourceBundle.getString("LOG_FAILED_TO_DESERIALIZE_CONTENT_HANDLER_EXC_",name, e.getLocalizedMessage()));
                }
            }
            else {
                // Reference address is not binary
                throw new EventException(LoggingCoreResourceBundle.getString("LOG_INVALID_JNDI_REFERENCE_EXC_",nameCtx.getNameInNamespace()));
            }
        }
        else {
            // Object is not a reference
            throw new EventException(LoggingCoreResourceBundle.getString("LOG_INVALID_JNDI_REFERENCE_EXC_",nameCtx.getNameInNamespace()));
        } 

        return result;
    }
}
