package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FeatureSituationImpl.java,v 1.1 2006/09/06 17:54:07 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Feature Situation</b></em>'.
 * 
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.FeatureSituationImpl#getFeatureDisposition <em>Feature Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FeatureSituationImpl extends SituationTypeImpl implements FeatureSituation, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 6050554845460888366L;

    /**
     * The default value of the '{@link #getFeatureDisposition() <em>Feature Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getFeatureDisposition()
     * @generated
     * @ordered
     */
    protected static final String FEATURE_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getFeatureDisposition() <em>Feature Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getFeatureDisposition()
     * @generated
     * @ordered
     */
    protected String featureDisposition = FEATURE_DISPOSITION_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FeatureSituationImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getFeatureSituation();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getFeatureDisposition() {
        return featureDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setFeatureDisposition(String newFeatureDisposition) {
        String oldFeatureDisposition = featureDisposition;
        featureDisposition = newFeatureDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.FEATURE_SITUATION__FEATURE_DISPOSITION, oldFeatureDisposition, featureDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.FEATURE_SITUATION__REASONING_SCOPE :
                return getReasoningScope();
            case EventPackage.FEATURE_SITUATION__FEATURE_DISPOSITION :
                return getFeatureDisposition();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.FEATURE_SITUATION__REASONING_SCOPE :
                setReasoningScope((String) newValue);
                return;
            case EventPackage.FEATURE_SITUATION__FEATURE_DISPOSITION :
                setFeatureDisposition((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.FEATURE_SITUATION__REASONING_SCOPE :
                setReasoningScope(REASONING_SCOPE_EDEFAULT);
                return;
            case EventPackage.FEATURE_SITUATION__FEATURE_DISPOSITION :
                setFeatureDisposition(FEATURE_DISPOSITION_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.FEATURE_SITUATION__REASONING_SCOPE :
                return REASONING_SCOPE_EDEFAULT == null ? reasoningScope != null : !REASONING_SCOPE_EDEFAULT.equals(reasoningScope);
            case EventPackage.FEATURE_SITUATION__FEATURE_DISPOSITION :
                return FEATURE_DISPOSITION_EDEFAULT == null ? featureDisposition != null : !FEATURE_DISPOSITION_EDEFAULT.equals(featureDisposition);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (featureDisposition: ");
        result.append(featureDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){

            super.validate();

            //Step 1:  Check for required properties:
            if(featureDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.FeatureSituation.FeatureDisposition")); 
            }

            //Step 2:  Check content of each property:
            if(featureDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.FeatureSituation.FeatureDisposition", featureDisposition, new Integer(featureDisposition.length()), new Integer(64)));
            }
        }
    }

	/**
	 * return a cloned (copy by value) object. This is a deep copy version, in which all the
	 * objects within this object will be copied by value.
	 *  
	 * @return Object
	 */
	public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
	}

	/**
	 * Overrides the <code>java.lang.Object</code>'s equals() API to 
	 * determine if the parameter <code>object</code> is equal to this object.
	 * 
	 * @param object The <code>java.lang.Object</code> to be compared to this object.
	 * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {

        synchronized(this){
            return EventHelpers.compareEObject(this, object);
        }
	}

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setFeatureDisposition(FEATURE_DISPOSITION_EDEFAULT);
    }
} //FeatureSituationImpl
