package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.hyades.logging.events.cbe.ContentHandler;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SimpleEventFactoryHomeImpl.java,v 1.2 2006/09/28 17:39:02 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * A simple concrete implementation of the <code>AbstractEventFactoryHome</code> 
 * abstract event factory home implementation used for creating event
 * factories with no associated <code>ContentHandler</code>.
 * <p>
 * This event factory home implementation is used to create an event factory that 
 * does not have an associated <code>ContentHandler</code>.  These event factory 
 * implementations are used to create events that do not have an associated 
 * <code>ContentHandler</code> nor a configuration template.
 * <p>
 *   
 *
 * @author Paul E Slauenwhite
 * @version 1.0.1
 * @since 1.0.1 
 * @see org.eclipse.hyades.logging.events.cbe.impl.AbstractEventFactoryHome
 */
public class SimpleEventFactoryHomeImpl extends AbstractEventFactoryHome {

    /**
     * @see org.eclipse.hyades.logging.events.cbe.impl.AbstractEventFactoryHome#resolveContentHandler()
     */
    public ContentHandler resolveContentHandler() {
        return null;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.impl.AbstractEventFactoryHome#createContentHandler(java.lang.String)
     */
    public ContentHandler createContentHandler(String factoryName) {
        return null;
    }
}