package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SituationImpl.java,v 1.1 2006/09/06 17:54:07 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Situation</b></em>'.
 * 
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.SituationImpl#getCategoryName <em>Category Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.SituationImpl#getSituationType <em>Situation Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SituationImpl extends SerializableImpl implements Situation, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 8478109585082201367L;

    /**
     * The default value of the '{@link #getCategoryName() <em>Category Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCategoryName()
     * @generated
     * @ordered
     */
    protected static final String CATEGORY_NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getCategoryName() <em>Category Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCategoryName()
     * @generated
     * @ordered
     */
    protected String categoryName = CATEGORY_NAME_EDEFAULT;

    /**
     * The cached value of the '{@link #getSituationType() <em>Situation Type</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSituationType()
     * @generated
     * @ordered
     */
    protected SituationType situationType = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SituationImpl() {
        super();
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setAvailableSituation(String, String, String,String)
     */
    public void setAvailableSituation(String reasoningScope, String availabilityDisposition, String operationDisposition, String processingDisposition) {
        AvailableSituation as = EventFactory.eINSTANCE.createAvailableSituation();
        as.setReasoningScope(reasoningScope);
        as.setAvailabilityDisposition(availabilityDisposition);
        as.setOperationDisposition(operationDisposition);
        as.setProcessingDisposition(processingDisposition);
        setSituationType(as);
        setCategoryName(AVAILABLE_SITUATION_CATEGORY);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setCategoryName(String newCategoryName) {
        String oldCategoryName = categoryName;
        categoryName = newCategoryName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.SITUATION__CATEGORY_NAME, oldCategoryName, categoryName));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setConfigureSituation(String,String)
     */
    public void setConfigureSituation(String reasoningScope, String successDisposition) {
        ConfigureSituation cs = EventFactory.eINSTANCE.createConfigureSituation();
        cs.setReasoningScope(reasoningScope);
        cs.setSuccessDisposition(successDisposition);
        setSituationType(cs);
        setCategoryName(CONFIGURE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setConnectSituation(String, String,String)
     */
    public void setConnectSituation(String reasoningScope, String situationDisposition, String successDisposition) {
        ConnectSituation cs = EventFactory.eINSTANCE.createConnectSituation();
        cs.setReasoningScope(reasoningScope);
        cs.setSituationDisposition(situationDisposition);
        cs.setSuccessDisposition(successDisposition);
        setSituationType(cs);
        setCategoryName(CONNECT_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setCreateSituation(String,String)
     */
    public void setCreateSituation(String reasoningScope, String successDisposition) {
        CreateSituation cs = EventFactory.eINSTANCE.createCreateSituation();
        cs.setReasoningScope(reasoningScope);
        cs.setSuccessDisposition(successDisposition);
        setSituationType(cs);
        setCategoryName(CREATE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setDependencySituation(String,String)
     */
    public void setDependencySituation(String reasoningScope, String dependencyDisposition) {
        DependencySituation ds = EventFactory.eINSTANCE.createDependencySituation();
        ds.setReasoningScope(reasoningScope);
        ds.setDependencyDisposition(dependencyDisposition);
        setSituationType(ds);
        setCategoryName(DEPENDENCY_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setDestroySituation(String,String)
     */
    public void setDestroySituation(String reasoningScope, String successDisposition) {
        DestroySituation ds = EventFactory.eINSTANCE.createDestroySituation();
        ds.setReasoningScope(reasoningScope);
        ds.setSuccessDisposition(successDisposition);
        setSituationType(ds);
        setCategoryName(DESTROY_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setFeatureSituation(String,String)
     */
    public void setFeatureSituation(String reasoningScope, String featureDisposition) {
        FeatureSituation fs = EventFactory.eINSTANCE.createFeatureSituation();
        fs.setReasoningScope(reasoningScope);
        fs.setFeatureDisposition(featureDisposition);
        setSituationType(fs);
        setCategoryName(FEATURE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setOtherSituation(String,String)
     */
    public void setOtherSituation(String reasoningScope, String any) {
        OtherSituation os = EventFactory.eINSTANCE.createOtherSituation();
        os.setReasoningScope(reasoningScope);
        os.setAny(any);
        setSituationType(os);
        setCategoryName(OTHER_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setReportSituation(String,String)
     */
    public void setReportSituation(String reasoningScope, String reportCategory) {
        ReportSituation rs = EventFactory.eINSTANCE.createReportSituation();
        rs.setReasoningScope(reasoningScope);
        rs.setReportCategory(reportCategory);
        setSituationType(rs);
        setCategoryName(REPORT_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setRequestSituation(String, String,String)
     */
    public void setRequestSituation(String reasoningScope, String situationQualifier, String successDisposition) {
        RequestSituation rs = EventFactory.eINSTANCE.createRequestSituation();
        rs.setReasoningScope(reasoningScope);
        rs.setSituationQualifier(situationQualifier);
        rs.setSuccessDisposition(successDisposition);
        setSituationType(rs);
        setCategoryName(REQUEST_SITUATION_CATEGORY);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSituationType(SituationType newSituationType) {
        if (newSituationType != situationType) {
            NotificationChain msgs = null;
            if (situationType != null)
                msgs = ((InternalEObject) situationType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EventPackage.SITUATION__SITUATION_TYPE, null, msgs);
            if (newSituationType != null)
                msgs = ((InternalEObject) newSituationType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EventPackage.SITUATION__SITUATION_TYPE, null, msgs);
            msgs = basicSetSituationType(newSituationType, msgs);
            if (msgs != null)
                msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.SITUATION__SITUATION_TYPE, newSituationType, newSituationType));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public SituationType getSituationType() {
        return situationType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setStartSituation(String, String,String)
     */
    public void setStartSituation(String reasoningScope, String situationQualifier, String successDisposition) {
        StartSituation ss = EventFactory.eINSTANCE.createStartSituation();
        ss.setReasoningScope(reasoningScope);
        ss.setSituationQualifier(situationQualifier);
        ss.setSuccessDisposition(successDisposition);
        setSituationType(ss);
        setCategoryName(START_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.Situation#setStopSituation(String, String,String)
     */
    public void setStopSituation(String reasoningScope, String situationQualifier, String successDisposition) {
        StopSituation ss = EventFactory.eINSTANCE.createStopSituation();
        ss.setReasoningScope(reasoningScope);
        ss.setSituationQualifier(situationQualifier);
        ss.setSuccessDisposition(successDisposition);
        setSituationType(ss);
        setCategoryName(STOP_SITUATION_CATEGORY);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetSituationType(SituationType newSituationType, NotificationChain msgs) {
        SituationType oldSituationType = situationType;
        situationType = newSituationType;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EventPackage.SITUATION__SITUATION_TYPE, oldSituationType, newSituationType);
            if (msgs == null)
                msgs = notification;
            else
                msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.SITUATION__CATEGORY_NAME :
                return getCategoryName();
            case EventPackage.SITUATION__SITUATION_TYPE :
                return getSituationType();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case EventPackage.SITUATION__SITUATION_TYPE :
                    return basicSetSituationType(null, msgs);
                default :
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.SITUATION__CATEGORY_NAME :
                return CATEGORY_NAME_EDEFAULT == null ? categoryName != null : !CATEGORY_NAME_EDEFAULT.equals(categoryName);
            case EventPackage.SITUATION__SITUATION_TYPE :
                return situationType != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.SITUATION__CATEGORY_NAME :
                setCategoryName((String) newValue);
                return;
            case EventPackage.SITUATION__SITUATION_TYPE :
                setSituationType((SituationType) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.SITUATION__CATEGORY_NAME :
                setCategoryName(CATEGORY_NAME_EDEFAULT);
                return;
            case EventPackage.SITUATION__SITUATION_TYPE :
                setSituationType((SituationType) null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (categoryName: ");
        result.append(categoryName);
        result.append(", situationType: ");
        result.append(situationType);
        result.append(')');
        return result.toString();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getSituation();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){

//          Step 1:  Check for required properties:
            if(situationType == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.SituationType")); 
            }

            if(categoryName == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.CategoryName")); 
            }

            //Step 2:  Check content of each property:
            situationType.validate();
            
            if(categoryName.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.CategoryName", categoryName, new Integer(categoryName.length()), new Integer(64)));
            }

            if((!categoryName.equals(START_SITUATION_CATEGORY)) && (!categoryName.equals(STOP_SITUATION_CATEGORY)) && (!categoryName.equals(CONNECT_SITUATION_CATEGORY)) && (!categoryName.equals(CONFIGURE_SITUATION_CATEGORY)) && (!categoryName.equals(REQUEST_SITUATION_CATEGORY)) && (!categoryName.equals(FEATURE_SITUATION_CATEGORY)) && (!categoryName.equals(DEPENDENCY_SITUATION_CATEGORY)) && (!categoryName.equals(CREATE_SITUATION_CATEGORY)) && (!categoryName.equals(DESTROY_SITUATION_CATEGORY)) && (!categoryName.equals(REPORT_SITUATION_CATEGORY)) && (!categoryName.equals(AVAILABLE_SITUATION_CATEGORY)) && (!categoryName.equals(OTHER_SITUATION_CATEGORY))){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_SITUATION_TYPE_EXC_", "CommonBaseEvent.Situation.CategoryName", categoryName, "[".concat(START_SITUATION_CATEGORY).concat(STOP_SITUATION_CATEGORY).concat(CONNECT_SITUATION_CATEGORY).concat(CONFIGURE_SITUATION_CATEGORY).concat(REQUEST_SITUATION_CATEGORY).concat(FEATURE_SITUATION_CATEGORY).concat(DEPENDENCY_SITUATION_CATEGORY).concat(CREATE_SITUATION_CATEGORY).concat(DESTROY_SITUATION_CATEGORY).concat(REPORT_SITUATION_CATEGORY).concat(AVAILABLE_SITUATION_CATEGORY).concat(OTHER_SITUATION_CATEGORY).concat("]")));
            }

            if ((categoryName.equals(START_SITUATION_CATEGORY) && !(situationType instanceof StartSituation))
                    || (categoryName.equals(STOP_SITUATION_CATEGORY) && !(situationType instanceof StopSituation))
                    || (categoryName.equals(CONNECT_SITUATION_CATEGORY) && !(situationType instanceof ConnectSituation))
                    || (categoryName.equals(CONFIGURE_SITUATION_CATEGORY) && !(situationType instanceof ConfigureSituation))
                    || (categoryName.equals(REQUEST_SITUATION_CATEGORY) && !(situationType instanceof RequestSituation))
                    || (categoryName.equals(FEATURE_SITUATION_CATEGORY) && !(situationType instanceof FeatureSituation))
                    || (categoryName.equals(DEPENDENCY_SITUATION_CATEGORY) && !(situationType instanceof DependencySituation))
                    || (categoryName.equals(CREATE_SITUATION_CATEGORY) && !(situationType instanceof CreateSituation))
                    || (categoryName.equals(DESTROY_SITUATION_CATEGORY) && !(situationType instanceof DestroySituation))
                    || (categoryName.equals(REPORT_SITUATION_CATEGORY) && !(situationType instanceof ReportSituation))
                    || (categoryName.equals(AVAILABLE_SITUATION_CATEGORY) && !(situationType instanceof AvailableSituation))
                    || (categoryName.equals(OTHER_SITUATION_CATEGORY) && !(situationType instanceof OtherSituation))) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_CATEGORY_MISMATCH_EXC_",  "CommonBaseEvent.Situation.SituationType", categoryName, situationType.getClass().getName()));
            }
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object arg0) {

        synchronized(this){
            return EventHelpers.compareEObject(this, arg0);
        }
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setCategoryName(CATEGORY_NAME_EDEFAULT);

        setSituationType(null);
    }
} //SituationImpl
