package org.eclipse.hyades.logging.events.cbe.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.TemplateContentHandler;

/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TemplateContentHandlerImpl.java,v 1.3 2008/01/24 02:29:30 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Concrete implementation of the <code>TemplateContentHandler</code>
 * interface for specifying a template event.
 * <p>
 * The template event is used to store event configuration properties that are
 * merged into the parameter event in the implementation of the
 * <code>completeEvent(CommonBaseEvent event)</code> API.
 * <p>
 * This implementation preserves the precedence rules for merging event
 * properties in the <code>completeEvent(CommonBaseEvent event)</code> API.
 * The precedence rules for merging event properties are as follows:
 * <p>
 * 1) The 'template event' contains the event properties to be merged into the
 * 'base event'. 2) String and primitive property values in the 'base event' are
 * considered 'golden' when the same property is set in the 'template event'. 3)
 * List property values in the 'template event' are concatenated to the
 * associated list property in the 'base event'. 4) Complex (e.g. objects
 * excluding strings) property values in the 'base event' are internally
 * compared to the associated 'template event' property using the above rules.
 * <p>
 * For security reasons, once a non-null template event has been set on
 * <code>TemplateContentHandler</code> instance, no other template event can
 * be set for the life cycle of the <code>TemplateContentHandler</code>
 * instance.
 * <p>
 * Synchronization is the responsibility of the caller based on their specific
 * run-time environment.
 * <p>
 * 
 * 
 * @author Paul E Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see org.eclipse.hyades.logging.events.cbe.TemplateContentHandler
 */
public class TemplateContentHandlerImpl implements TemplateContentHandler {

    protected CommonBaseEvent templateEvent = null;

    protected boolean isTemplateEventSet = false;

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ContentHandler#completeEvent(org.eclipse.hyades.logging.events.cbe.CommonBaseEvent)
     */
    public void completeEvent(CommonBaseEvent event) throws CompletionException {

        if (!isTemplateEventSet) { throw new CompletionException("No content handler template"); }

        if (event == null) {

            //Assign a copy of the template event:
            event = ((CommonBaseEvent) (EcoreUtil.copy(templateEvent)));
        } else if (!event.isComplete()) {

            if ((!event.isSetCreationTime()) && (templateEvent.isSetCreationTime())) {
                event.setCreationTime(templateEvent.getCreationTime());
            }

            if ((!event.isSetElapsedTime()) && (templateEvent.isSetElapsedTime())) {
                event.setElapsedTime(templateEvent.getElapsedTime());
            }

            if ((!event.isSetPriority()) && (templateEvent.isSetPriority())) {
                event.setPriority(templateEvent.getPriority());
            }

            if ((!event.isSetRepeatCount()) && (templateEvent.isSetRepeatCount())) {
                event.setRepeatCount(templateEvent.getRepeatCount());
            }

            if ((!event.isSetSequenceNumber()) && (templateEvent.isSetSequenceNumber())) {
                event.setSequenceNumber(templateEvent.getSequenceNumber());
            }

            if ((!event.isSetSeverity()) && (templateEvent.isSetSeverity())) {
                event.setSeverity(templateEvent.getSeverity());
            }

            String stringProperty = null;

            if (event.getExtensionName() == null) {

                stringProperty = templateEvent.getExtensionName();

                if (stringProperty != null) {
                    event.setExtensionName(stringProperty);
                }
            }

            if (event.getLocalInstanceId() == null) {

                stringProperty = templateEvent.getLocalInstanceId();

                if (stringProperty != null) {
                    event.setLocalInstanceId(stringProperty);
                }
            }

            if (event.getGlobalInstanceId() == null) {

                stringProperty = templateEvent.getGlobalInstanceId();

                if (stringProperty != null) {
                    event.setGlobalInstanceId(stringProperty);
                }
            }

            if (event.getMsg() == null) {

                stringProperty = templateEvent.getMsg();

                if (stringProperty != null) {
                    event.setMsg(stringProperty);
                }
            }

            if (event.getVersion() == null) {

                stringProperty = templateEvent.getVersion();

                if (stringProperty != null) {
                    event.setVersion(stringProperty);
                }
            }

            List mergeListProperty = templateEvent.getAny();
            Iterator mergeListIterator = null;

            if (mergeListProperty != null) {

                mergeListIterator = mergeListProperty.iterator();

                while (mergeListIterator.hasNext()) {
                    event.addAny(((String) (mergeListIterator.next())));
                }
            }

            mergeListProperty = templateEvent.getExtendedDataElements();

            if (mergeListProperty != null) {

                mergeListIterator = mergeListProperty.iterator();

                while (mergeListIterator.hasNext()) {

                    //Add a copy of the ExtendedDataElement:
                    event.addExtendedDataElement(((ExtendedDataElement) (EcoreUtil.copy(((ExtendedDataElement) (mergeListIterator.next()))))));
                }
            }

            mergeListProperty = templateEvent.getContextDataElements();

            if (mergeListProperty != null) {

                mergeListIterator = mergeListProperty.iterator();

                while (mergeListIterator.hasNext()) {

                    //Add a copy of the ContextDataElement:
                    event.addContextDataElement(((ContextDataElement) (EcoreUtil.copy(((ContextDataElement) (mergeListIterator.next()))))));
                }
            }

            mergeListProperty = templateEvent.getAssociatedEvents();

            if (mergeListProperty != null) {

                mergeListIterator = mergeListProperty.iterator();

                while (mergeListIterator.hasNext()) {

                    //Add a copy of the AssociatedEvent:
                    event.addAssociatedEvent(((AssociatedEvent) (EcoreUtil.copy(((AssociatedEvent) (mergeListIterator.next()))))));
                }
            }

            ComponentIdentification mergeComponentId = templateEvent.getSourceComponentId();
            ComponentIdentification baseComponentId = null;

            if (mergeComponentId != null) {

                baseComponentId = event.getSourceComponentId();

                if (baseComponentId == null) {

                    //Assign a copy of the source ComponentIdentification:
                    event.setSourceComponentId((ComponentIdentification) (EcoreUtil.copy(mergeComponentId)));
                } else {

                    if (baseComponentId.getLocation() == null) {

                        stringProperty = mergeComponentId.getLocation();

                        if (stringProperty != null) {
                            baseComponentId.setLocation(stringProperty);
                        }
                    }

                    if (baseComponentId.getLocationType() == null) {

                        stringProperty = mergeComponentId.getLocationType();

                        if (stringProperty != null) {
                            baseComponentId.setLocationType(stringProperty);
                        }
                    }

                    if (baseComponentId.getApplication() == null) {

                        stringProperty = mergeComponentId.getApplication();

                        if (stringProperty != null) {
                            baseComponentId.setApplication(stringProperty);
                        }
                    }

                    if (baseComponentId.getExecutionEnvironment() == null) {

                        stringProperty = mergeComponentId.getExecutionEnvironment();

                        if (stringProperty != null) {
                            baseComponentId.setExecutionEnvironment(stringProperty);
                        }
                    }

                    if (baseComponentId.getComponent() == null) {

                        stringProperty = mergeComponentId.getComponent();

                        if (stringProperty != null) {
                            baseComponentId.setComponent(stringProperty);
                        }
                    }

                    if (baseComponentId.getSubComponent() == null) {

                        stringProperty = mergeComponentId.getSubComponent();

                        if (stringProperty != null) {
                            baseComponentId.setSubComponent(stringProperty);
                        }
                    }

                    if (baseComponentId.getComponentIdType() == null) {

                        stringProperty = mergeComponentId.getComponentIdType();

                        if (stringProperty != null) {
                            baseComponentId.setComponentIdType(stringProperty);
                        }
                    }

                    if (baseComponentId.getInstanceId() == null) {

                        stringProperty = mergeComponentId.getInstanceId();

                        if (stringProperty != null) {
                            baseComponentId.setInstanceId(stringProperty);
                        }
                    }

                    if (baseComponentId.getProcessId() == null) {

                        stringProperty = mergeComponentId.getProcessId();

                        if (stringProperty != null) {
                            baseComponentId.setProcessId(stringProperty);
                        }
                    }

                    if (baseComponentId.getThreadId() == null) {

                        stringProperty = mergeComponentId.getThreadId();

                        if (stringProperty != null) {
                            baseComponentId.setThreadId(stringProperty);
                        }
                    }

                    if (baseComponentId.getComponentType() == null) {

                        stringProperty = mergeComponentId.getComponentType();

                        if (stringProperty != null) {
                            baseComponentId.setComponentType(stringProperty);
                        }
                    }
                }
            }

            mergeComponentId = templateEvent.getReporterComponentId();
            baseComponentId = null;

            if (mergeComponentId != null) {

                baseComponentId = event.getReporterComponentId();

                if (baseComponentId == null) {

                    //Assign a copy of the reporter ComponentIdentification:
                    event.setReporterComponentId((ComponentIdentification) (EcoreUtil.copy(mergeComponentId)));
                } else {

                    if (baseComponentId.getLocation() == null) {

                        stringProperty = mergeComponentId.getLocation();

                        if (stringProperty != null) {
                            baseComponentId.setLocation(stringProperty);
                        }
                    }

                    if (baseComponentId.getLocationType() == null) {

                        stringProperty = mergeComponentId.getLocationType();

                        if (stringProperty != null) {
                            baseComponentId.setLocationType(stringProperty);
                        }
                    }

                    if (baseComponentId.getApplication() == null) {

                        stringProperty = mergeComponentId.getApplication();

                        if (stringProperty != null) {
                            baseComponentId.setApplication(stringProperty);
                        }
                    }

                    if (baseComponentId.getExecutionEnvironment() == null) {

                        stringProperty = mergeComponentId.getExecutionEnvironment();

                        if (stringProperty != null) {
                            baseComponentId.setExecutionEnvironment(stringProperty);
                        }
                    }

                    if (baseComponentId.getComponent() == null) {

                        stringProperty = mergeComponentId.getComponent();

                        if (stringProperty != null) {
                            baseComponentId.setComponent(stringProperty);
                        }
                    }

                    if (baseComponentId.getSubComponent() == null) {

                        stringProperty = mergeComponentId.getSubComponent();

                        if (stringProperty != null) {
                            baseComponentId.setSubComponent(stringProperty);
                        }
                    }

                    if (baseComponentId.getComponentIdType() == null) {

                        stringProperty = mergeComponentId.getComponentIdType();

                        if (stringProperty != null) {
                            baseComponentId.setComponentIdType(stringProperty);
                        }
                    }

                    if (baseComponentId.getInstanceId() == null) {

                        stringProperty = mergeComponentId.getInstanceId();

                        if (stringProperty != null) {
                            baseComponentId.setInstanceId(stringProperty);
                        }
                    }

                    if (baseComponentId.getProcessId() == null) {

                        stringProperty = mergeComponentId.getProcessId();

                        if (stringProperty != null) {
                            baseComponentId.setProcessId(stringProperty);
                        }
                    }

                    if (baseComponentId.getThreadId() == null) {

                        stringProperty = mergeComponentId.getThreadId();

                        if (stringProperty != null) {
                            baseComponentId.setThreadId(stringProperty);
                        }
                    }

                    if (baseComponentId.getComponentType() == null) {

                        stringProperty = mergeComponentId.getComponentType();

                        if (stringProperty != null) {
                            baseComponentId.setComponentType(stringProperty);
                        }
                    }
                }
            }

            MsgDataElement mergeMsgDataElement = templateEvent.getMsgDataElement();
            MsgDataElement baseMsgDataElement = null;

            if (mergeMsgDataElement != null) {

                baseMsgDataElement = event.getMsgDataElement();

                if (baseMsgDataElement == null) {

                    //Assign a copy of the MsgDataElement:
                    event.setMsgDataElement((MsgDataElement) (EcoreUtil.copy(mergeMsgDataElement)));
                } else {

                    if (baseMsgDataElement.getMsgId() == null) {

                        stringProperty = mergeMsgDataElement.getMsgId();

                        if (stringProperty != null) {
                            baseMsgDataElement.setMsgId(stringProperty);
                        }
                    }

                    if (baseMsgDataElement.getMsgIdType() == null) {

                        stringProperty = mergeMsgDataElement.getMsgIdType();

                        if (stringProperty != null) {
                            baseMsgDataElement.setMsgIdType(stringProperty);
                        }
                    }

                    if (baseMsgDataElement.getMsgCatalogId() == null) {

                        stringProperty = mergeMsgDataElement.getMsgCatalogId();

                        if (stringProperty != null) {
                            baseMsgDataElement.setMsgCatalogId(stringProperty);
                        }
                    }

                    if (baseMsgDataElement.getMsgCatalog() == null) {

                        stringProperty = mergeMsgDataElement.getMsgCatalog();

                        if (stringProperty != null) {
                            baseMsgDataElement.setMsgCatalog(stringProperty);
                        }
                    }

                    if (baseMsgDataElement.getMsgLocale() == null) {

                        stringProperty = mergeMsgDataElement.getMsgLocale();

                        if (stringProperty != null) {
                            baseMsgDataElement.setMsgLocale(stringProperty);
                        }
                    }

                    if (baseMsgDataElement.getMsgCatalogType() == null) {

                        stringProperty = mergeMsgDataElement.getMsgCatalogType();

                        if (stringProperty != null) {
                            baseMsgDataElement.setMsgCatalogType(stringProperty);
                        }
                    }

                    mergeListProperty = mergeMsgDataElement.getMsgCatalogTokens();

                    if (mergeListProperty != null) {

                        mergeListIterator = mergeListProperty.iterator();

                        while (mergeListIterator.hasNext()) {

                            //Add a copy of the MsgCatalogToken:
                            baseMsgDataElement.addMsgCatalogToken(((MsgCatalogToken) (EcoreUtil.copy(((MsgCatalogToken) (mergeListIterator.next()))))));
                        }
                    }
                }
            }

            Situation mergeSituation = templateEvent.getSituation();
            Situation baseSituation = null;

            if (mergeSituation != null) {

                baseSituation = event.getSituation();

                if (baseSituation == null) {

                    //Assign a copy of the MsgDataElement:
                    event.setSituation((Situation) (EcoreUtil.copy(mergeSituation)));
                } else {

                    if (baseSituation.getCategoryName() == null) {

                        stringProperty = mergeSituation.getCategoryName();

                        if (stringProperty != null) {
                            baseSituation.setCategoryName(stringProperty);
                        }
                    }

                    SituationType mergeSituationType = mergeSituation.getSituationType();
                    SituationType baseSituationType = null;

                    if (mergeSituationType != null) {

                        baseSituationType = baseSituation.getSituationType();

                        if (baseSituationType == null) {

                            //Assign a copy of the MsgDataElement:
                            baseSituation.setSituationType((SituationType) (EcoreUtil.copy(mergeSituationType)));
                        }

                        else if (baseSituationType instanceof StartSituation) {

                            if (mergeSituationType instanceof StartSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((StartSituation) (baseSituationType)).getSuccessDisposition() == null) {

                                    stringProperty = ((StartSituation) (mergeSituationType)).getSuccessDisposition();

                                    if (stringProperty != null) {
                                        ((StartSituation) (baseSituationType)).setSuccessDisposition(stringProperty);
                                    }
                                }

                                if (((StartSituation) (baseSituationType)).getSituationQualifier() == null) {

                                    stringProperty = ((StartSituation) (mergeSituationType)).getSituationQualifier();

                                    if (stringProperty != null) {
                                        ((StartSituation) (baseSituationType)).setSituationQualifier(stringProperty);
                                    }
                                }
                            }
                        } else if (baseSituationType instanceof StopSituation) {

                            if (mergeSituationType instanceof StopSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((StopSituation) (baseSituationType)).getSuccessDisposition() == null) {

                                    stringProperty = ((StopSituation) (mergeSituationType)).getSuccessDisposition();

                                    if (stringProperty != null) {
                                        ((StopSituation) (baseSituationType)).setSuccessDisposition(stringProperty);
                                    }
                                }

                                if (((StopSituation) (baseSituationType)).getSituationQualifier() == null) {

                                    stringProperty = ((StopSituation) (mergeSituationType)).getSituationQualifier();

                                    if (stringProperty != null) {
                                        ((StopSituation) (baseSituationType)).setSituationQualifier(stringProperty);
                                    }
                                }
                            }
                        } else if (baseSituationType instanceof ConnectSituation) {

                            if (mergeSituationType instanceof ConnectSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((ConnectSituation) (baseSituationType)).getSuccessDisposition() == null) {

                                    stringProperty = ((ConnectSituation) (mergeSituationType)).getSuccessDisposition();

                                    if (stringProperty != null) {
                                        ((ConnectSituation) (baseSituationType)).setSuccessDisposition(stringProperty);
                                    }
                                }

                                if (((ConnectSituation) (baseSituationType)).getSituationDisposition() == null) {

                                    stringProperty = ((ConnectSituation) (mergeSituationType)).getSituationDisposition();

                                    if (stringProperty != null) {
                                        ((ConnectSituation) (baseSituationType)).setSituationDisposition(stringProperty);
                                    }
                                }
                            }
                        } else if (baseSituationType instanceof ReportSituation) {

                            if (mergeSituationType instanceof ReportSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((ReportSituation) (baseSituationType)).getReportCategory() == null) {

                                    stringProperty = ((ReportSituation) (mergeSituationType)).getReportCategory();

                                    if (stringProperty != null) {
                                        ((ReportSituation) (baseSituationType)).setReportCategory(stringProperty);
                                    }
                                }
                            }
                        }

                        else if (baseSituationType instanceof FeatureSituation) {

                            if (mergeSituationType instanceof FeatureSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((FeatureSituation) (baseSituationType)).getFeatureDisposition() == null) {

                                    stringProperty = ((FeatureSituation) (mergeSituationType)).getFeatureDisposition();

                                    if (stringProperty != null) {
                                        ((FeatureSituation) (baseSituationType)).setFeatureDisposition(stringProperty);
                                    }
                                }
                            }
                        } else if (baseSituationType instanceof ConfigureSituation) {

                            if (mergeSituationType instanceof ConfigureSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((ConfigureSituation) (baseSituationType)).getSuccessDisposition() == null) {

                                    stringProperty = ((ConfigureSituation) (mergeSituationType)).getSuccessDisposition();

                                    if (stringProperty != null) {
                                        ((ConfigureSituation) (baseSituationType)).setSuccessDisposition(stringProperty);
                                    }
                                }
                            }
                        } else if (baseSituationType instanceof DependencySituation) {

                            if (mergeSituationType instanceof DependencySituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((DependencySituation) (baseSituationType)).getDependencyDisposition() == null) {

                                    stringProperty = ((DependencySituation) (mergeSituationType)).getDependencyDisposition();

                                    if (stringProperty != null) {
                                        ((DependencySituation) (baseSituationType)).setDependencyDisposition(stringProperty);
                                    }
                                }
                            }
                        } else if (baseSituationType instanceof CreateSituation) {

                            if (mergeSituationType instanceof CreateSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((CreateSituation) (baseSituationType)).getSuccessDisposition() == null) {

                                    stringProperty = ((CreateSituation) (mergeSituationType)).getSuccessDisposition();

                                    if (stringProperty != null) {
                                        ((CreateSituation) (baseSituationType)).setSuccessDisposition(stringProperty);
                                    }
                                }
                            }
                        }

                        else if (baseSituationType instanceof DestroySituation) {

                            if (mergeSituationType instanceof DestroySituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((DestroySituation) (baseSituationType)).getSuccessDisposition() == null) {

                                    stringProperty = ((DestroySituation) (mergeSituationType)).getSuccessDisposition();

                                    if (stringProperty != null) {
                                        ((DestroySituation) (baseSituationType)).setSuccessDisposition(stringProperty);
                                    }
                                }
                            }
                        }

                        else if (baseSituationType instanceof AvailableSituation) {

                            if (mergeSituationType instanceof AvailableSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((AvailableSituation) (baseSituationType)).getOperationDisposition() == null) {

                                    stringProperty = ((AvailableSituation) (mergeSituationType)).getOperationDisposition();

                                    if (stringProperty != null) {
                                        ((AvailableSituation) (baseSituationType)).setOperationDisposition(stringProperty);
                                    }
                                }

                                if (((AvailableSituation) (baseSituationType)).getProcessingDisposition() == null) {

                                    stringProperty = ((AvailableSituation) (mergeSituationType)).getProcessingDisposition();

                                    if (stringProperty != null) {
                                        ((AvailableSituation) (baseSituationType)).setProcessingDisposition(stringProperty);
                                    }
                                }

                                if (((AvailableSituation) (baseSituationType)).getAvailabilityDisposition() == null) {

                                    stringProperty = ((AvailableSituation) (mergeSituationType)).getAvailabilityDisposition();

                                    if (stringProperty != null) {
                                        ((AvailableSituation) (baseSituationType)).setAvailabilityDisposition(stringProperty);
                                    }
                                }
                            }
                        }

                        else if (baseSituationType instanceof RequestSituation) {

                            if (mergeSituationType instanceof RequestSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }

                                if (((RequestSituation) (baseSituationType)).getSuccessDisposition() == null) {

                                    stringProperty = ((RequestSituation) (mergeSituationType)).getSuccessDisposition();

                                    if (stringProperty != null) {
                                        ((RequestSituation) (baseSituationType)).setSuccessDisposition(stringProperty);
                                    }
                                }

                                if (((RequestSituation) (baseSituationType)).getSituationQualifier() == null) {

                                    stringProperty = ((RequestSituation) (mergeSituationType)).getSituationQualifier();

                                    if (stringProperty != null) {
                                        ((RequestSituation) (baseSituationType)).setSituationQualifier(stringProperty);
                                    }
                                }
                            }
                        }

                        else if (baseSituationType instanceof OtherSituation) {

                            if (mergeSituationType instanceof OtherSituation) {

                                if (baseSituationType.getReasoningScope() == null) {

                                    stringProperty = mergeSituationType.getReasoningScope();

                                    if (stringProperty != null) {
                                        baseSituationType.setReasoningScope(stringProperty);
                                    }
                                }
                                if (((OtherSituation) (baseSituationType)).getAny() == null) {

                                    stringProperty = ((OtherSituation) (mergeSituationType)).getAny();

                                    if (stringProperty != null) {
                                        ((OtherSituation) (baseSituationType)).setAny(stringProperty);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.TemplateContentHandler#setTemplateEvent(org.eclipse.hyades.logging.events.cbe.CommonBaseEvent)
     */
    public void setTemplateEvent(CommonBaseEvent templateEvent) {

        if ((!isTemplateEventSet) && (templateEvent != null)) {

            this.templateEvent = templateEvent;

            isTemplateEventSet = true;
        }
    }
}