package org.eclipse.hyades.logging.events.cbe.util;

import java.io.Serializable;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventAdapterFactory.java,v 1.2 2006/09/28 17:39:06 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1 
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage
 * @generated
 */
public class EventAdapterFactory extends AdapterFactoryImpl {

    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static EventPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EventAdapterFactory() {
        if (modelPackage == null) {
            modelPackage = EventPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    public boolean isFactoryForType(Object object) {
        if (object == modelPackage) {
            return true;
        }
        if (object instanceof EObject) {
            return ((EObject) object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch the delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventSwitch modelSwitch = new EventSwitch() {
        public Object caseAssociatedEvent(AssociatedEvent object) {
            return createAssociatedEventAdapter();
        }
        public Object caseAssociationEngine(AssociationEngine object) {
            return createAssociationEngineAdapter();
        }
        public Object caseAvailableSituation(AvailableSituation object) {
            return createAvailableSituationAdapter();
        }
        public Object caseCommonBaseEvent(CommonBaseEvent object) {
            return createCommonBaseEventAdapter();
        }
        public Object caseComponentIdentification(ComponentIdentification object) {
            return createComponentIdentificationAdapter();
        }
        public Object caseConfigureSituation(ConfigureSituation object) {
            return createConfigureSituationAdapter();
        }
        public Object caseConnectSituation(ConnectSituation object) {
            return createConnectSituationAdapter();
        }
        public Object caseContextDataElement(ContextDataElement object) {
            return createContextDataElementAdapter();
        }
        public Object caseCreateSituation(CreateSituation object) {
            return createCreateSituationAdapter();
        }
        public Object caseDependencySituation(DependencySituation object) {
            return createDependencySituationAdapter();
        }
        public Object caseDestroySituation(DestroySituation object) {
            return createDestroySituationAdapter();
        }
        public Object caseExtendedDataElement(ExtendedDataElement object) {
            return createExtendedDataElementAdapter();
        }
        public Object caseFeatureSituation(FeatureSituation object) {
            return createFeatureSituationAdapter();
        }
        public Object caseMsgCatalogToken(MsgCatalogToken object) {
            return createMsgCatalogTokenAdapter();
        }
        public Object caseMsgDataElement(MsgDataElement object) {
            return createMsgDataElementAdapter();
        }
        public Object caseOtherSituation(OtherSituation object) {
            return createOtherSituationAdapter();
        }
        public Object caseReportSituation(ReportSituation object) {
            return createReportSituationAdapter();
        }
        public Object caseRequestSituation(RequestSituation object) {
            return createRequestSituationAdapter();
        }
        public Object caseSituation(Situation object) {
            return createSituationAdapter();
        }
        public Object caseSituationType(SituationType object) {
            return createSituationTypeAdapter();
        }
        public Object caseStartSituation(StartSituation object) {
            return createStartSituationAdapter();
        }
        public Object caseStopSituation(StopSituation object) {
            return createStopSituationAdapter();
        }
        public Object caseSerializable(Serializable object) {
            return createSerializableAdapter();
        }
        public Object defaultCase(EObject object) {
            return createEObjectAdapter();
        }
    };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    public Adapter createAdapter(Notifier target) {
        return (Adapter) modelSwitch.doSwitch((EObject) target);
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent <em>Associated Event</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.AssociatedEvent
     * @generated
     */
    public Adapter createAssociatedEventAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine <em>Association Engine</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.AssociationEngine
     * @generated
     */
    public Adapter createAssociationEngineAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation <em>Available Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.AvailableSituation
     * @generated
     */
    public Adapter createAvailableSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent <em>Common Base Event</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent
     * @generated
     */
    public Adapter createCommonBaseEventAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification <em>Component Identification</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification
     * @generated
     */
    public Adapter createComponentIdentificationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.ConfigureSituation <em>Configure Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.ConfigureSituation
     * @generated
     */
    public Adapter createConfigureSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation <em>Connect Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.ConnectSituation
     * @generated
     */
    public Adapter createConnectSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement <em>Context Data Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.ContextDataElement
     * @generated
     */
    public Adapter createContextDataElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.CreateSituation <em>Create Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.CreateSituation
     * @generated
     */
    public Adapter createCreateSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.DependencySituation <em>Dependency Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.DependencySituation
     * @generated
     */
    public Adapter createDependencySituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.DestroySituation <em>Destroy Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.DestroySituation
     * @generated
     */
    public Adapter createDestroySituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement <em>Extended Data Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement
     * @generated
     */
    public Adapter createExtendedDataElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.FeatureSituation <em>Feature Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.FeatureSituation
     * @generated
     */
    public Adapter createFeatureSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.MsgCatalogToken <em>Msg Catalog Token</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.MsgCatalogToken
     * @generated
     */
    public Adapter createMsgCatalogTokenAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement <em>Msg Data Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement
     * @generated
     */
    public Adapter createMsgDataElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.OtherSituation <em>Other Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.OtherSituation
     * @generated
     */
    public Adapter createOtherSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.ReportSituation <em>Report Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.ReportSituation
     * @generated
     */
    public Adapter createReportSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.RequestSituation <em>Request Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.RequestSituation
     * @generated
     */
    public Adapter createRequestSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.Situation <em>Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.Situation
     * @generated
     */
    public Adapter createSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.SituationType <em>Situation Type</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.SituationType
     * @generated
     */
    public Adapter createSituationTypeAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.StartSituation <em>Start Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.StartSituation
     * @generated
     */
    public Adapter createStartSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link org.eclipse.hyades.logging.events.cbe.StopSituation <em>Stop Situation</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see org.eclipse.hyades.logging.events.cbe.StopSituation
     * @generated
     */
    public Adapter createStopSituationAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link java.io.Serializable <em>Serializable</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see java.io.Serializable
     * @generated
     */
    public Adapter createSerializableAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter() {
        return null;
    }

} //EventAdapterFactory
