package org.eclipse.hyades.logging.events.cbe.util;

import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventListener.java,v 1.1 2006/09/06 17:54:02 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Listener interface for receiving notification to process 
 * {@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent}s and 
 * {@link org.eclipse.hyades.logging.events.cbe.AssociationEngine}s when 
 * de-serializing a stream of Common Base Event and Association Engine 
 * XML fragments.
 * <p>
 * When de-serializing a stream of Common Base Event and Association Engine XML 
 * fragments, callers can process de-serialized 
 * {@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent}s and 
 * {@link org.eclipse.hyades.logging.events.cbe.AssociationEngine}s on a separate
 * thread before the entire stream of Common Base Event and Association Engine 
 * XML fragments has been processed, resulting in a high level of parallelism and 
 * improved efficiency.
 * <p>
 * The {@link org.eclipse.hyades.logging.events.cbe.util.EventFormatter} provides 
 * methods for callers to register an implementation of this listener interface when 
 * de-serializing a stream of Common Base Event and Association Engine XML fragments.  
 * <p>
 * Noteworthy, callers to the methods in the 
 * {@link org.eclipse.hyades.logging.events.cbe.util.EventFormatter} are 
 * responsible for listener instantiation, registration and clean-up.
 * <p>
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @version     February 13, 2006
 * @since       February 6, 2006
 * @see         org.eclipse.hyades.logging.events.cbe.util.EventFormatter
 * @provisional As of TPTP v4.2.0, this class is marked as 'provisional'.
 */
public interface EventListener {

	/**
	 * Receives notification to process a 
	 * {@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent} when 
	 * de-serializing a Common Base Event XML fragment.
	 * <p>
	 * Once a Common Base Event XML fragment has been de-serialized by the 
	 * {@link org.eclipse.hyades.logging.events.cbe.util.EventFormatter}, 
	 * a {@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent} is 
	 * constructed and broadcast to this method of the registered  
	 * {@link org.eclipse.hyades.logging.events.cbe.util.EventListener} 
	 * implementation for processing.
	 * <p>
	 * 
	 * @param commonBaseEvent The {@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent} 
	 * to be processed.
   * @provisional As of TPTP v4.2.0, this method is marked as 'provisional'.
	 */
	public void processCommonBaseEvent(CommonBaseEvent commonBaseEvent);
	
	/**
	 * Receives notification to process a 
	 * {@link org.eclipse.hyades.logging.events.cbe.AssociationEngine} when 
	 * de-serializing an Association Engine XML fragment.
	 * <p>
	 * Once an Association Engine XML fragment has been de-serialized by the 
	 * {@link org.eclipse.hyades.logging.events.cbe.util.EventFormatter}, 
	 * an {@link org.eclipse.hyades.logging.events.cbe.AssociationEngine} is 
	 * constructed and broadcast to this method of the registered  
	 * {@link org.eclipse.hyades.logging.events.cbe.util.EventListener}  
	 * implementation for processing.
	 * <p>
	 * 
	 * @param associationEngine The {@link org.eclipse.hyades.logging.events.cbe.AssociationEngine} 
	 * to be processed.
   * @provisional As of TPTP v4.2.0, this method is marked as 'provisional'.
	 */
	public void processAssociationEngine(AssociationEngine associationEngine);
}
